require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_ATOMIC_H_)) {
    eval 'sub _MACHINE_ATOMIC_H_ () {1;}' unless defined(&_MACHINE_ATOMIC_H_);
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub LOCK () {"lock";}' unless defined(&LOCK);
	} else {
	    eval 'sub LOCK () {1;}' unless defined(&LOCK);
	}
	eval 'sub atomic_cas_uint {
	    my($_p, $_e, $_n) = @_;
    	    eval q( &_atomic_cas_uint(($_p), ($_e), ($_n)));
	}' unless defined(&atomic_cas_uint);
	eval 'sub atomic_cas_ulong {
	    my($_p, $_e, $_n) = @_;
    	    eval q( &_atomic_cas_ulong(($_p), ($_e), ($_n)));
	}' unless defined(&atomic_cas_ulong);
	eval 'sub atomic_cas_ptr {
	    my($_p, $_e, $_n) = @_;
    	    eval q( &_atomic_cas_ptr(($_p), ($_e), ($_n)));
	}' unless defined(&atomic_cas_ptr);
	eval 'sub atomic_swap_uint {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_uint(($_p), ($_n)));
	}' unless defined(&atomic_swap_uint);
	eval 'sub atomic_swap_32 {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_uint(($_p), ($_n)));
	}' unless defined(&atomic_swap_32);
	eval 'sub atomic_swap_ulong {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_ulong(($_p), ($_n)));
	}' unless defined(&atomic_swap_ulong);
	eval 'sub atomic_swap_64 {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_64(($_p), ($_n)));
	}' unless defined(&atomic_swap_64);
	eval 'sub atomic_swap_ptr {
	    my($_p, $_n) = @_;
    	    eval q( &_atomic_swap_ptr(($_p), ($_n)));
	}' unless defined(&atomic_swap_ptr);
	eval 'sub atomic_inc_int {
	    my($_p) = @_;
    	    eval q( &_atomic_inc_int($_p));
	}' unless defined(&atomic_inc_int);
	eval 'sub atomic_inc_long {
	    my($_p) = @_;
    	    eval q( &_atomic_inc_long($_p));
	}' unless defined(&atomic_inc_long);
	eval 'sub atomic_dec_int {
	    my($_p) = @_;
    	    eval q( &_atomic_dec_int($_p));
	}' unless defined(&atomic_dec_int);
	eval 'sub atomic_dec_long {
	    my($_p) = @_;
    	    eval q( &_atomic_dec_long($_p));
	}' unless defined(&atomic_dec_long);
	eval 'sub atomic_add_int {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_add_int($_p, $_v));
	}' unless defined(&atomic_add_int);
	eval 'sub atomic_add_long {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_add_long($_p, $_v));
	}' unless defined(&atomic_add_long);
	eval 'sub atomic_sub_int {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_sub_int($_p, $_v));
	}' unless defined(&atomic_sub_int);
	eval 'sub atomic_sub_long {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_sub_long($_p, $_v));
	}' unless defined(&atomic_sub_long);
	eval 'sub atomic_add_int_nv {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_add_int_nv($_p, $_v));
	}' unless defined(&atomic_add_int_nv);
	eval 'sub atomic_add_long_nv {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_add_long_nv($_p, $_v));
	}' unless defined(&atomic_add_long_nv);
	eval 'sub atomic_sub_int_nv {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_sub_int_nv($_p, $_v));
	}' unless defined(&atomic_sub_int_nv);
	eval 'sub atomic_sub_long_nv {
	    my($_p, $_v) = @_;
    	    eval q( &_atomic_sub_long_nv($_p, $_v));
	}' unless defined(&atomic_sub_long_nv);
	eval 'sub __membar {
	    my($_f) = @_;
    	    eval q( &do {  &__asm  &__volatile($_f ::: \\"memory\\"); }  &while (0));
	}' unless defined(&__membar);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub membar_enter () {
	        eval q( &__membar(\\"lock; addl $0,0(%%esp)\\"));
	    }' unless defined(&membar_enter);
	    eval 'sub membar_exit () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_exit);
	    eval 'sub membar_producer () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_producer);
	    eval 'sub membar_consumer () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_consumer);
	    eval 'sub membar_sync () {
	        eval q( &__membar(\\"lock; addl $0,0(%%esp)\\"));
	    }' unless defined(&membar_sync);
	} else {
	    eval 'sub membar_enter () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_enter);
	    eval 'sub membar_exit () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_exit);
	    eval 'sub membar_producer () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_producer);
	    eval 'sub membar_consumer () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_consumer);
	    eval 'sub membar_sync () {
	        eval q( &__membar(\\"\\"));
	    }' unless defined(&membar_sync);
	}
	eval 'sub virtio_membar_producer () {
	    eval q( &__membar(\\"\\"));
	}' unless defined(&virtio_membar_producer);
	eval 'sub virtio_membar_consumer () {
	    eval q( &__membar(\\"\\"));
	}' unless defined(&virtio_membar_consumer);
	eval 'sub virtio_membar_sync () {
	    eval q( &__membar(\\"lock; addl $0,0(%%esp)\\"));
	}' unless defined(&virtio_membar_sync);
	eval 'sub i386_atomic_testset_uq {
	    my($ptr,$val) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&i386_atomic_testset_uq);
	eval 'sub i386_atomic_testset_ul {
	    my($ptr,$val) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&i386_atomic_testset_ul);
	eval 'sub i386_atomic_testset_i {
	    my($ptr,$val) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&i386_atomic_testset_i);
	eval 'sub i386_atomic_setbits_l {
	    my($ptr,$bits) = @_;
    	    eval q({  &__asm  &volatile( &LOCK \\" orl %1,%0\\" : \\"=m\\" (*$ptr) : \\"ir\\" ($bits)); });
	}' unless defined(&i386_atomic_setbits_l);
	eval 'sub i386_atomic_clearbits_l {
	    my($ptr,$bits) = @_;
    	    eval q({ $bits = ~$bits;  &__asm  &volatile( &LOCK \\" andl %1,%0\\" : \\"=m\\" (*$ptr) : \\"ir\\" ($bits)); });
	}' unless defined(&i386_atomic_clearbits_l);
	eval 'sub futex_atomic_ucas_int32 () { &ucas_32;}' unless defined(&futex_atomic_ucas_int32);
	eval 'sub atomic_setbits_int () { &i386_atomic_setbits_l;}' unless defined(&atomic_setbits_int);
	eval 'sub atomic_clearbits_int () { &i386_atomic_clearbits_l;}' unless defined(&atomic_clearbits_int);
	undef(&LOCK) if defined(&LOCK);
    }
}
1;
