require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_ALPHA_CPU_H_)) {
    eval 'sub _MACHINE_ALPHA_CPU_H_ () {1;}' unless defined(&_MACHINE_ALPHA_CPU_H_);
    eval 'sub ALPHA_PCB_FLAGS_FEN () {0x1;}' unless defined(&ALPHA_PCB_FLAGS_FEN);
    eval 'sub ALPHA_PCB_FLAGS_PME () {0x4000000000000000;}' unless defined(&ALPHA_PCB_FLAGS_PME);
    eval 'sub ALPHA_HWFRAME_PS () {0;}' unless defined(&ALPHA_HWFRAME_PS);
    eval 'sub ALPHA_HWFRAME_PC () {1;}' unless defined(&ALPHA_HWFRAME_PC);
    eval 'sub ALPHA_HWFRAME_GP () {2;}' unless defined(&ALPHA_HWFRAME_GP);
    eval 'sub ALPHA_HWFRAME_A0 () {3;}' unless defined(&ALPHA_HWFRAME_A0);
    eval 'sub ALPHA_HWFRAME_A1 () {4;}' unless defined(&ALPHA_HWFRAME_A1);
    eval 'sub ALPHA_HWFRAME_A2 () {5;}' unless defined(&ALPHA_HWFRAME_A2);
    eval 'sub ALPHA_HWFRAME_SIZE () {6;}' unless defined(&ALPHA_HWFRAME_SIZE);
    eval 'sub ALPHA_PSL_USERMODE () {0x8;}' unless defined(&ALPHA_PSL_USERMODE);
    eval 'sub ALPHA_PSL_IPL_MASK () {0x7;}' unless defined(&ALPHA_PSL_IPL_MASK);
    eval 'sub ALPHA_PSL_IPL_0 () {0x;}' unless defined(&ALPHA_PSL_IPL_0);
    eval 'sub ALPHA_PSL_IPL_SOFT () {0x1;}' unless defined(&ALPHA_PSL_IPL_SOFT);
    eval 'sub ALPHA_PSL_IPL_IO () {0x4;}' unless defined(&ALPHA_PSL_IPL_IO);
    eval 'sub ALPHA_PSL_IPL_CLOCK () {0x5;}' unless defined(&ALPHA_PSL_IPL_CLOCK);
    eval 'sub ALPHA_PSL_IPL_HIGH () {0x6;}' unless defined(&ALPHA_PSL_IPL_HIGH);
    eval 'sub ALPHA_PSL_MUST_BE_ZERO () {0xfffffffffffffff0;}' unless defined(&ALPHA_PSL_MUST_BE_ZERO);
    eval 'sub ALPHA_PSL_USERSET () { &ALPHA_PSL_USERMODE;}' unless defined(&ALPHA_PSL_USERSET);
    eval 'sub ALPHA_PSL_USERCLR () {( &ALPHA_PSL_MUST_BE_ZERO |  &ALPHA_PSL_IPL_MASK);}' unless defined(&ALPHA_PSL_USERCLR);
    eval 'sub ALPHA_INTR_XPROC () {0;}' unless defined(&ALPHA_INTR_XPROC);
    eval 'sub ALPHA_INTR_CLOCK () {1;}' unless defined(&ALPHA_INTR_CLOCK);
    eval 'sub ALPHA_INTR_ERROR () {2;}' unless defined(&ALPHA_INTR_ERROR);
    eval 'sub ALPHA_INTR_DEVICE () {3;}' unless defined(&ALPHA_INTR_DEVICE);
    eval 'sub ALPHA_INTR_PERF () {4;}' unless defined(&ALPHA_INTR_PERF);
    eval 'sub ALPHA_INTR_PASSIVE () {5;}' unless defined(&ALPHA_INTR_PASSIVE);
    eval 'sub ALPHA_MCES_IMP () {0xffffffff00000000;}' unless defined(&ALPHA_MCES_IMP);
    eval 'sub ALPHA_MCES_RSVD () {0xffffffe0;}' unless defined(&ALPHA_MCES_RSVD);
    eval 'sub ALPHA_MCES_DSC () {0x10;}' unless defined(&ALPHA_MCES_DSC);
    eval 'sub ALPHA_MCES_DPC () {0x8;}' unless defined(&ALPHA_MCES_DPC);
    eval 'sub ALPHA_MCES_PCE () {0x4;}' unless defined(&ALPHA_MCES_PCE);
    eval 'sub ALPHA_MCES_SCE () {0x2;}' unless defined(&ALPHA_MCES_SCE);
    eval 'sub ALPHA_MCES_MIP () {0x1;}' unless defined(&ALPHA_MCES_MIP);
    eval 'sub ALPHA_LOGOUT_FLAGS_RETRY () {0x80000000;}' unless defined(&ALPHA_LOGOUT_FLAGS_RETRY);
    eval 'sub ALPHA_LOGOUT_FLAGS_SE () {0x40000000;}' unless defined(&ALPHA_LOGOUT_FLAGS_SE);
    eval 'sub ALPHA_LOGOUT_FLAGS_SBZ () {0x3fffffff;}' unless defined(&ALPHA_LOGOUT_FLAGS_SBZ);
    eval 'sub ALPHA_LOGOUT_NOT_BUILT () {0xffffffffffffffff);}' unless defined(&ALPHA_LOGOUT_NOT_BUILT);
    eval 'sub ALPHA_LOGOUT_PAL_AREA {
        my($lap) = @_;
	    eval q((($lap) + 16));
    }' unless defined(&ALPHA_LOGOUT_PAL_AREA);
    eval 'sub ALPHA_LOGOUT_PAL_SIZE {
        my($lap) = @_;
	    eval q((($lap)-> &la_cpu_offset - 16));
    }' unless defined(&ALPHA_LOGOUT_PAL_SIZE);
    eval 'sub ALPHA_LOGOUT_CPU_AREA {
        my($lap) = @_;
	    eval q((($lap) + ($lap)-> &la_cpu_offset));
    }' unless defined(&ALPHA_LOGOUT_CPU_AREA);
    eval 'sub ALPHA_LOGOUT_CPU_SIZE {
        my($lap) = @_;
	    eval q((($lap)-> &la_system_offset - ($lap)-> &la_cpu_offset));
    }' unless defined(&ALPHA_LOGOUT_CPU_SIZE);
    eval 'sub ALPHA_LOGOUT_SYSTEM_AREA {
        my($lap) = @_;
	    eval q((($lap) + ($lap)-> &la_system_offset));
    }' unless defined(&ALPHA_LOGOUT_SYSTEM_AREA);
    eval 'sub ALPHA_LOGOUT_SYSTEM_SIZE {
        my($lap) = @_;
	    eval q((($lap)-> &la_frame_size - ($lap)-> &la_system_offset));
    }' unless defined(&ALPHA_LOGOUT_SYSTEM_SIZE);
    eval 'sub ALPHA_SYS_ERROR () {0x620;}' unless defined(&ALPHA_SYS_ERROR);
    eval 'sub ALPHA_PROC_ERROR () {0x630;}' unless defined(&ALPHA_PROC_ERROR);
    eval 'sub ALPHA_SYS_MCHECK () {0x660;}' unless defined(&ALPHA_SYS_MCHECK);
    eval 'sub ALPHA_PROC_MCHECK () {0x670;}' unless defined(&ALPHA_PROC_MCHECK);
    eval 'sub ALPHA_ENV_MCHECK () {0x680;}' unless defined(&ALPHA_ENV_MCHECK);
    eval 'sub ALPHA_USEG_BASE () {0;}' unless defined(&ALPHA_USEG_BASE);
    eval 'sub ALPHA_USEG_END () {0x3ffffffffff;}' unless defined(&ALPHA_USEG_END);
    eval 'sub ALPHA_K0SEG_BASE () {0xfffffc0000000000;}' unless defined(&ALPHA_K0SEG_BASE);
    eval 'sub ALPHA_K0SEG_END () {0xfffffdffffffffff;}' unless defined(&ALPHA_K0SEG_END);
    eval 'sub ALPHA_K1SEG_BASE () {0xfffffe0000000000;}' unless defined(&ALPHA_K1SEG_BASE);
    eval 'sub ALPHA_K1SEG_END () {0xffffffffffffffff;}' unless defined(&ALPHA_K1SEG_END);
    eval 'sub ALPHA_K0SEG_TO_PHYS {
        my($x) = @_;
	    eval q((($x) & ~ &ALPHA_K0SEG_BASE));
    }' unless defined(&ALPHA_K0SEG_TO_PHYS);
    eval 'sub ALPHA_PHYS_TO_K0SEG {
        my($x) = @_;
	    eval q((($x) |  &ALPHA_K0SEG_BASE));
    }' unless defined(&ALPHA_PHYS_TO_K0SEG);
    eval 'sub ALPHA_PTE_VALID () {0x1;}' unless defined(&ALPHA_PTE_VALID);
    eval 'sub ALPHA_PTE_FAULT_ON_READ () {0x2;}' unless defined(&ALPHA_PTE_FAULT_ON_READ);
    eval 'sub ALPHA_PTE_FAULT_ON_WRITE () {0x4;}' unless defined(&ALPHA_PTE_FAULT_ON_WRITE);
    eval 'sub ALPHA_PTE_FAULT_ON_EXECUTE () {0x8;}' unless defined(&ALPHA_PTE_FAULT_ON_EXECUTE);
    eval 'sub ALPHA_PTE_ASM () {0x10;}' unless defined(&ALPHA_PTE_ASM);
    eval 'sub ALPHA_PTE_GRANULARITY () {0x60;}' unless defined(&ALPHA_PTE_GRANULARITY);
    eval 'sub ALPHA_PTE_PROT () {0xff00;}' unless defined(&ALPHA_PTE_PROT);
    eval 'sub ALPHA_PTE_KR () {0x100;}' unless defined(&ALPHA_PTE_KR);
    eval 'sub ALPHA_PTE_UR () {0x200;}' unless defined(&ALPHA_PTE_UR);
    eval 'sub ALPHA_PTE_KW () {0x1000;}' unless defined(&ALPHA_PTE_KW);
    eval 'sub ALPHA_PTE_UW () {0x2000;}' unless defined(&ALPHA_PTE_UW);
    eval 'sub ALPHA_PTE_WRITE () {( &ALPHA_PTE_KW |  &ALPHA_PTE_UW);}' unless defined(&ALPHA_PTE_WRITE);
    eval 'sub ALPHA_PTE_SOFTWARE () {0xffff0000;}' unless defined(&ALPHA_PTE_SOFTWARE);
    eval 'sub ALPHA_PTE_PALCODE () {(~ &ALPHA_PTE_SOFTWARE);}' unless defined(&ALPHA_PTE_PALCODE);
    eval 'sub ALPHA_PTE_PFN () {0xffffffff00000000;}' unless defined(&ALPHA_PTE_PFN);
    eval 'sub ALPHA_PTE_TO_PFN {
        my($pte) = @_;
	    eval q((($pte) >> 32));
    }' unless defined(&ALPHA_PTE_TO_PFN);
    eval 'sub ALPHA_PTE_FROM_PFN {
        my($pfn) = @_;
	    eval q((($pfn) << 32));
    }' unless defined(&ALPHA_PTE_FROM_PFN);
    eval 'sub ALPHA_KENTRY_INT () {0;}' unless defined(&ALPHA_KENTRY_INT);
    eval 'sub ALPHA_KENTRY_ARITH () {1;}' unless defined(&ALPHA_KENTRY_ARITH);
    eval 'sub ALPHA_KENTRY_MM () {2;}' unless defined(&ALPHA_KENTRY_MM);
    eval 'sub ALPHA_KENTRY_IF () {3;}' unless defined(&ALPHA_KENTRY_IF);
    eval 'sub ALPHA_KENTRY_UNA () {4;}' unless defined(&ALPHA_KENTRY_UNA);
    eval 'sub ALPHA_KENTRY_SYS () {5;}' unless defined(&ALPHA_KENTRY_SYS);
    eval 'sub ALPHA_MMCSR_INVALTRANS () {0;}' unless defined(&ALPHA_MMCSR_INVALTRANS);
    eval 'sub ALPHA_MMCSR_ACCESS () {1;}' unless defined(&ALPHA_MMCSR_ACCESS);
    eval 'sub ALPHA_MMCSR_FOR () {2;}' unless defined(&ALPHA_MMCSR_FOR);
    eval 'sub ALPHA_MMCSR_FOE () {3;}' unless defined(&ALPHA_MMCSR_FOE);
    eval 'sub ALPHA_MMCSR_FOW () {4;}' unless defined(&ALPHA_MMCSR_FOW);
    eval 'sub ALPHA_IF_CODE_BPT () {0;}' unless defined(&ALPHA_IF_CODE_BPT);
    eval 'sub ALPHA_IF_CODE_BUGCHK () {1;}' unless defined(&ALPHA_IF_CODE_BUGCHK);
    eval 'sub ALPHA_IF_CODE_GENTRAP () {2;}' unless defined(&ALPHA_IF_CODE_GENTRAP);
    eval 'sub ALPHA_IF_CODE_FEN () {3;}' unless defined(&ALPHA_IF_CODE_FEN);
    eval 'sub ALPHA_IF_CODE_OPDEC () {4;}' unless defined(&ALPHA_IF_CODE_OPDEC);
    if(defined(&_KERNEL)) {
	eval 'sub ALPHA_TBIA () {
	    eval q( &alpha_pal_tbi(-2, 0));
	}' unless defined(&ALPHA_TBIA);
	eval 'sub ALPHA_TBIAP () {
	    eval q( &alpha_pal_tbi(-1, 0));
	}' unless defined(&ALPHA_TBIAP);
	eval 'sub ALPHA_TBISI {
	    my($va) = @_;
    	    eval q( &alpha_pal_tbi(1, ($va)));
	}' unless defined(&ALPHA_TBISI);
	eval 'sub ALPHA_TBISD {
	    my($va) = @_;
    	    eval q( &alpha_pal_tbi(2, ($va)));
	}' unless defined(&ALPHA_TBISD);
	eval 'sub ALPHA_TBIS {
	    my($va) = @_;
    	    eval q( &alpha_pal_tbi(3, ($va)));
	}' unless defined(&ALPHA_TBIS);
    }
    eval 'sub ALPHA_AMASK_BWX () {0x1;}' unless defined(&ALPHA_AMASK_BWX);
    eval 'sub ALPHA_AMASK_FIX () {0x2;}' unless defined(&ALPHA_AMASK_FIX);
    eval 'sub ALPHA_AMASK_CIX () {0x4;}' unless defined(&ALPHA_AMASK_CIX);
    eval 'sub ALPHA_AMASK_MVI () {0x100;}' unless defined(&ALPHA_AMASK_MVI);
    eval 'sub ALPHA_AMASK_PAT () {0x200;}' unless defined(&ALPHA_AMASK_PAT);
    eval 'sub ALPHA_AMASK_ALL () {( &ALPHA_AMASK_BWX| &ALPHA_AMASK_FIX|  &ALPHA_AMASK_CIX| &ALPHA_AMASK_MVI|  &ALPHA_AMASK_PAT);}' unless defined(&ALPHA_AMASK_ALL);
    eval 'sub ALPHA_AMASK_BITS () {"\\20\\12PAT\\11MVI\\3CIX\\2FIX\\1BWX";}' unless defined(&ALPHA_AMASK_BITS);
    eval 'sub ALPHA_IMPLVER_EV4 () {0;}' unless defined(&ALPHA_IMPLVER_EV4);
    eval 'sub ALPHA_IMPLVER_EV5 () {1;}' unless defined(&ALPHA_IMPLVER_EV5);
    eval 'sub ALPHA_IMPLVER_EV6 () {2;}' unless defined(&ALPHA_IMPLVER_EV6);
    if(defined(&_KERNEL)) {
	eval 'sub ALPHA_WHAMI_MAXID () {63;}' unless defined(&ALPHA_WHAMI_MAXID);
	eval 'sub ALPHA_MAXPROCS () {( &ALPHA_WHAMI_MAXID + 1);}' unless defined(&ALPHA_MAXPROCS);
    }
    eval 'sub alpha_mb () {
        eval q( &__asm  &volatile(\\"mb\\" : : : \\"memory\\"));
    }' unless defined(&alpha_mb);
    eval 'sub alpha_wmb () {
        eval q( &__asm  &volatile(\\"mb\\" : : : \\"memory\\"));
    }' unless defined(&alpha_wmb);
    if(defined(&_KERNEL) || defined(&_STANDALONE)) {
	require 'machine/pal.ph';
	eval 'sub alpha_pal_draina () {
	    eval q( &__asm  &volatile(\\"call_pal %0 # PAL_draina\\" : : \\"i\\" ( &PAL_draina) : \\"memory\\"));
	}' unless defined(&alpha_pal_draina);
	eval 'sub alpha_pal_imb () {
	    eval q( &__asm  &volatile(\\"call_pal %0 # PAL_imb\\" : : \\"i\\" ( &PAL_imb) : \\"memory\\"));
	}' unless defined(&alpha_pal_imb);
	eval 'sub alpha_pal_rdmces {
	    my($void) = @_;
    	    eval q({  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_rdmces\\" : \\"=r\\" ( &v0) : \\"i\\" ( &PAL_OSF1_rdmces) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); ( &v0); });
	}' unless defined(&alpha_pal_rdmces);
	eval 'sub alpha_pal_rdps {
	    my($void) = @_;
    	    eval q({  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_rdps\\" : \\"=r\\" ( &v0) : \\"i\\" ( &PAL_OSF1_rdps) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); ( &v0); });
	}' unless defined(&alpha_pal_rdps);
	eval 'sub alpha_pal_rdunique {
	    my($void) = @_;
    	    eval q({  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %1 # PAL_rdunique\\" : \\"=r\\" ( &v0) : \\"i\\" ( &PAL_rdunique)); ( &v0); });
	}' unless defined(&alpha_pal_rdunique);
	eval 'sub alpha_pal_rdusp {
	    my($void) = @_;
    	    eval q({  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_rdusp\\" : \\"=r\\" ( &v0) : \\"i\\" ( &PAL_OSF1_rdusp) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); ( &v0); });
	}' unless defined(&alpha_pal_rdusp);
	eval 'sub alpha_pal_rdval {
	    my($void) = @_;
    	    eval q({  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_rdval\\" : \\"=r\\" ( &v0) : \\"i\\" ( &PAL_OSF1_rdval) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); ( &v0); });
	}' unless defined(&alpha_pal_rdval);
	eval 'sub alpha_pal_swpctx {
	    my($ctx) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $ctx;  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %2 # PAL_OSF1_swpctx\\" : \\"=r\\" ( &a0), \\"=r\\" ( &v0) : \\"i\\" ( &PAL_OSF1_swpctx), \\"0\\" ( &a0) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\", \\"memory\\"); ( &v0); });
	}' unless defined(&alpha_pal_swpctx);
	eval 'sub alpha_pal_swpipl {
	    my($ipl) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $ipl;  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %2 # PAL_OSF1_swpipl\\" : \\"=r\\" ( &a0), \\"=r\\" ( &v0) : \\"i\\" ( &PAL_OSF1_swpipl), \\"0\\" ( &a0) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\", \\"memory\\"); ( &v0); });
	}' unless defined(&alpha_pal_swpipl);
	eval 'sub alpha_pal_tbi {
	    my($op,$va) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $op;  &register  &unsigned long a1 __asm(\\"$17\\") = $va;  &__asm  &volatile(\\"call_pal %2 # PAL_OSF1_tbi\\" : \\"=r\\" ( &a0), \\"=r\\" ( &a1) : \\"i\\" ( &PAL_OSF1_tbi), \\"0\\" ( &a0), \\"1\\" ( &a1) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); });
	}' unless defined(&alpha_pal_tbi);
	eval 'sub alpha_pal_whami {
	    my($void) = @_;
    	    eval q({  &register  &unsigned long v0 __asm(\\"$0\\");  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_whami\\" : \\"=r\\" ( &v0) : \\"i\\" ( &PAL_OSF1_whami) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); ( &v0); });
	}' unless defined(&alpha_pal_whami);
	eval 'sub alpha_pal_wrfen {
	    my($onoff) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $onoff;  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_wrfen\\" : \\"=r\\" ( &a0) : \\"i\\" ( &PAL_OSF1_wrfen), \\"0\\" ( &a0) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); });
	}' unless defined(&alpha_pal_wrfen);
	eval 'sub alpha_pal_wripir {
	    my($cpu_id) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $cpu_id;  &__asm  &volatile(\\"call_pal %1 # PAL_ipir\\" : \\"=r\\" ( &a0) : \\"i\\" ( &PAL_ipir), \\"0\\" ( &a0) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); });
	}' unless defined(&alpha_pal_wripir);
	eval 'sub alpha_pal_wrunique {
	    my($unique) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $unique;  &__asm  &volatile(\\"call_pal %1 # PAL_wrunique\\" : \\"=r\\" ( &a0) : \\"i\\" ( &PAL_wrunique), \\"0\\" ( &a0)); });
	}' unless defined(&alpha_pal_wrunique);
	eval 'sub alpha_pal_wrusp {
	    my($usp) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $usp;  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_wrusp\\" : \\"=r\\" ( &a0) : \\"i\\" ( &PAL_OSF1_wrusp), \\"0\\" ( &a0) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); });
	}' unless defined(&alpha_pal_wrusp);
	eval 'sub alpha_pal_wrmces {
	    my($mces) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $mces;  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_wrmces\\" : \\"=r\\" ( &a0) : \\"i\\" ( &PAL_OSF1_wrmces), \\"0\\" ( &a0) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); });
	}' unless defined(&alpha_pal_wrmces);
	eval 'sub alpha_pal_wrval {
	    my($val) = @_;
    	    eval q({  &register  &unsigned long a0 __asm(\\"$16\\") = $val;  &__asm  &volatile(\\"call_pal %1 # PAL_OSF1_wrval\\" : \\"=r\\" ( &a0) : \\"i\\" ( &PAL_OSF1_wrval), \\"0\\" ( &a0) : \\"$1\\", \\"$22\\", \\"$23\\", \\"$24\\", \\"$25\\"); });
	}' unless defined(&alpha_pal_wrval);
    }
}
1;
