/*	$OpenBSD: tfork_thread.S,v 1.5 2015/09/05 06:22:47 guenther Exp $	*/

/*
 * Copyright (c) 2005 Tim Wiess <tim@nop.cx>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/syscall.h>
#include <machine/asm.h>

ENTRY(__tfork_thread)
	/* sanity check */
	cmpwi	%r5, 0
	beq	1f
	
	/* call __tfork */
	li	%r0, SYS___tfork
	sc
	cmpwi	%r0, 0
	bne	2f
	
	/* check if we are parent or child */
	cmpwi	%r3, 0
	bnelr
	
	/* child */
	mtlr	%r5		/* fp */
	mr	%r3, %r6	/* arg */
	subi	%r1, %r1, 16	/* fixup sp to get headroom */
	blrl
	
	/* child returned, call __threxit */
	li	%r0, SYS___threxit
	sc
1:
	li	%r3, -1
2:
	b	_C_LABEL(___cerror)
END(__tfork_thread)
