/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

public class MidiSynth {
    static int noteNumber = 0;
    static int velocity = 0;
    static int duration = 0;
    static Synthesizer synth = null;
    static Sequencer sequencer = null;
    static Receiver receiver = null;
    static Transmitter transmitter = null;
    static MidiChannel[] channels = null;
    static Instrument[] instruments = null;
    static Sequence sequence = null;
    static Soundbank soundbank = null;
    static int sysResolution = 32;
    static final int sysBpm = 120;
    static int userResolution = 16;
    static int userBpm = 120;
    static int tickAccum;
    static Track track;
    static Integer[] channelPrograms;
    static Integer[] channelBends;
    static HashMap instrumentNumbers;

    public static void midiInit(StringTokenizer stringTokenizer) {
        int n;
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();
            sequencer = MidiSystem.getSequencer();
        }
        catch (Exception exception) {
            ErrorDialog.showExit("gs:midi-init", "MIDI system unavailable - will exit");
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string = Base64Coder.decodeString(stringTokenizer.nextToken());
            try {
                soundbank = MidiSystem.getSoundbank(new File(string));
            }
            catch (Exception exception) {
                ErrorDialog.show("gs:midi-init", "Cannot read soundbank:" + string);
            }
        } else {
            soundbank = synth.getDefaultSoundbank();
        }
        instruments = soundbank.getInstruments();
        for (n = 0; n < Math.min(128, instruments.length); ++n) {
            instrumentNumbers.put(instruments[n].getName(), n);
        }
        synth.loadInstrument(instruments[0]);
        channelPrograms = new Integer[16];
        channelBends = new Integer[16];
        for (n = 0; n < 16; ++n) {
            MidiSynth.channelPrograms[n] = 0;
            MidiSynth.channelBends[n] = 8192;
        }
        channels = synth.getChannels();
    }

    public static void playNote(StringTokenizer stringTokenizer) {
        int n = 0;
        noteNumber = Integer.parseInt(stringTokenizer.nextToken());
        noteNumber = Math.min(127, Math.max(0, noteNumber));
        duration = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = duration * 60000 / (userBpm * userResolution);
        velocity = Integer.parseInt(stringTokenizer.nextToken());
        velocity = Math.min(127, Math.max(0, velocity));
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
            n = Math.min(8192, Math.max(-8192, n));
        }
        if (channels == null) {
            ErrorDialog.showExit("gs:play-note", "MIDI system no initialized - will exit");
            return;
        }
        MidiChannel midiChannel = channels[n3];
        midiChannel.setPitchBend(channelBends[n3] + n);
        midiChannel.noteOn(noteNumber, velocity);
        try {
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        midiChannel.noteOff(noteNumber);
    }

    public static void getInstruments() {
        if (instruments == null) {
            ErrorDialog.showExit("gs:get-instruments", "MIDI system no initialized - will exit");
            return;
        }
        guiserver.out.print("(set 'gs:instruments '( ");
        for (int i = 0; i < Math.min(128, instruments.length); ++i) {
            Instrument instrument = instruments[i];
            guiserver.out.print("\"" + Base64Coder.encodeString(instrument.getName()) + "\" ");
        }
        guiserver.out.println(")) ");
        guiserver.out.flush();
    }

    public static void midiPatch(StringTokenizer stringTokenizer) {
        String string = Base64Coder.decodeString(stringTokenizer.nextToken());
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (synth == null) {
            ErrorDialog.showExit("gs:midi-patch", "MIDI system no initialized - will exit");
        }
        int n2 = 0;
        try {
            n2 = (Integer)instrumentNumbers.get(string);
        }
        catch (Exception exception) {
            ErrorDialog.show("gs:midi-patch", "Instrument not known");
        }
        try {
            synth.loadInstrument(instruments[n2]);
        }
        catch (Exception exception) {
            ErrorDialog.show("gs:midi-path", "Instrument not available");
        }
        MidiChannel midiChannel = channels[n];
        midiChannel.programChange(n2);
        MidiSynth.channelPrograms[n] = n2;
    }

    public static void midiBPM(StringTokenizer stringTokenizer) {
        userBpm = Integer.parseInt(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            userResolution = Integer.parseInt(stringTokenizer.nextToken());
        }
    }

    public static void channelBend(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        n2 = Math.min(8191, Math.max(-8192, n2));
        MidiSynth.channelBends[n] = n2 + 8192;
        MidiChannel midiChannel = channels[n];
    }

    public static void channelReverb(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        n2 = Math.min(127, Math.max(0, n2));
        MidiChannel midiChannel = channels[n];
        midiChannel.controlChange(91, n2);
    }

    public static void channelPressure(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        n2 = Math.min(127, Math.max(0, n2));
        MidiChannel midiChannel = channels[n];
        midiChannel.setChannelPressure(n2);
    }

    public static void addTrack(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        MidiChannel midiChannel = channels[n];
        int n2 = channelPrograms[n];
        float f = userResolution * 120 / userBpm;
        if (sequence == null) {
            try {
                sequence = new Sequence(0.0f, sysResolution);
            }
            catch (Exception exception) {
                ErrorDialog.showExit("gs:add-track", "Cannot create sequence - will exit");
            }
        }
        track = sequence.createTrack();
        tickAccum = 0;
        synth.loadInstrument(instruments[n2]);
        MidiSynth.createShortMessage(192, n, n2, 64);
        tickAccum = 1;
        int n3 = 8192;
        while (stringTokenizer.hasMoreTokens()) {
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            int n5 = Integer.parseInt(stringTokenizer.nextToken());
            int n6 = Integer.parseInt(stringTokenizer.nextToken());
            int n7 = Integer.parseInt(stringTokenizer.nextToken());
            n7 = Math.min(8191, Math.max(-8192, n7)) + channelBends[n];
            int n8 = (int)((float)n5 * f / 8.0f);
            if (n7 != n3) {
                MidiSynth.createShortMessage(224, 0, n7 & 0x7F, n7 >> 7 & 0xFF);
                ++tickAccum;
                --n8;
                n3 = n7;
            }
            MidiSynth.createShortMessage(144, n, n4, n6);
            tickAccum += n8;
            MidiSynth.createShortMessage(128, n, n4, n6);
        }
    }

    public static void createShortMessage(int n, int n2, int n3, int n4) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3, n4);
            MidiEvent midiEvent = new MidiEvent(shortMessage, tickAccum);
            track.add(midiEvent);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            ErrorDialog.show("MIDI system", "Cannot create message channel:" + n2 + " tick:" + tickAccum);
            invalidMidiDataException.printStackTrace();
        }
    }

    public static void muteTrack(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (stringTokenizer.nextToken().equals("nil")) {
            sequencer.setTrackMute(n, false);
        } else {
            sequencer.setTrackMute(n, true);
        }
    }

    public static void soloTrack(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (stringTokenizer.nextToken().equals("nil")) {
            sequencer.setTrackSolo(n, false);
        } else {
            sequencer.setTrackSolo(n, false);
        }
    }

    public static void playSequence(StringTokenizer stringTokenizer) {
        if (synth == null) {
            ErrorDialog.showExit("gs:play-sequence", "MIDI system not initialized - will exit");
        }
        if (sequence == null) {
            ErrorDialog.showExit("gs:play-sequence", "No tracks created - will exit");
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        long l = Long.parseLong(stringTokenizer.nextToken());
        long l2 = Long.parseLong(stringTokenizer.nextToken());
        try {
            if (!sequencer.isOpen()) {
                sequencer.open();
            }
            sequencer.setSequence(sequence);
            if (l2 == -1L) {
                l2 = sequence.getTickLength();
            }
            sequencer.setTickPosition(n);
            sequencer.start();
            sequencer.setLoopStartPoint(l);
            sequencer.setLoopEndPoint(l2);
            sequencer.setLoopCount(n2);
            sequencer.setTempoInBPM(120.0f);
        }
        catch (Exception exception) {
            ErrorDialog.showExit("gs:play-sequence", "Cannot start sequencer - will exit");
        }
    }

    public static void stopSequence() {
        if (sequencer == null) {
            ErrorDialog.show("gs:play-sequence", "No sequencer to stop");
        }
        sequencer.stop();
        long l = sequencer.getTickPosition();
        guiserver.out.print("(set 'gs:tick-position " + l + ")");
        guiserver.out.flush();
    }

    public static void saveSequence(StringTokenizer stringTokenizer) {
        String string = Base64Coder.decodeString(stringTokenizer.nextToken());
        File file = new File(string);
        try {
            int[] nArray = MidiSystem.getMidiFileTypes(sequence);
            if (nArray.length == 0) {
                ErrorDialog.show("gs:save-sequence", "Cannot save sequence");
            } else if (MidiSystem.write(sequence, nArray[0], file) == -1) {
                ErrorDialog.show("gs:save-sequence", "Cannot write file");
            }
        }
        catch (Exception exception) {
            ErrorDialog.show("gs:save-sequence", "Cannot write file:" + string);
        }
    }

    public static void midiClose() {
        if (synth != null) {
            synth.close();
        }
        if (sequence != null) {
            sequencer.close();
        }
        synth = null;
        sequencer = null;
    }

    static {
        channelPrograms = null;
        channelBends = null;
        instrumentNumbers = new HashMap();
    }
}

