/***************************************************************************
                           cfilemanager.h  -  description
                             -------------------
    begin                : Sat Aug 03 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFILEMANAGER_H
#define CFILEMANAGER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cthread.h>
#include <dclib/cmessagehandler.h>
#include <dclib/core/csingleton.h>
#include <dclib/cconfig.h>
#include <dclib/csharelist.h>

class CStringList;
class CThreadStringList;
class CFileInfo;
class CFileManagerInfo;
class CFileManager;
class CByteArray;
class CSearchIndex;

#ifdef WIN32
template class DLL_EXPORT CSingleton<CFileManager>;
#endif

class DLL_EXPORT CFileManager : public CSingleton<CFileManager>, public CThread {

public:
	/** */
	CFileManager();
	/** */
	virtual ~CFileManager();

	/** */
	ulonglong GetShareSize();
	/** */
	unsigned long GetShareBufferSize( eShareBufferType type );
	/** */
	int GetShareBuffer( eShareBufferType type, CByteArray * sharebuffer, bool decompress = FALSE );

	/** */
	CStringList * Search( CString s );
	/** */
	CStringList * SearchHash( CString s );
	/** */
	bool GetFileBaseObject( CString id, struct filebaseobject * fbo, CString & filename );
	/** */
	CString GetHash( ulonglong hbi );
	
	/** */
	bool CreateShareList();
	/** */
	bool CreateHashList();
	/** */
	void CreateSearchIndex();

	/** */
	ulonglong CalcShareSize();

	/** thread callbackfunction */
	virtual void Thread( CObject * Object );

private:
	/** */
	void ThreadCreateSearchIndex();
	/** */
	void ThreadCreateHashList();
	/** */
	void ThreadCreateShareList();
	/** */
	void ThreadCreateShareList( int depth, CString curr, CString relpath, double percent );

	/** */
	int FileManagerCallback( CObject *, CObject * );

	/** */
	ulonglong CalcShareSize( int depth, CString base, CString curr, CString relpath );
	/** */
	void InitFileTypeList();

	/** */
	CStringList * m_pFileNameList;
	/** */
	CStringList * m_pFileTypeList;

	/** return the filetype */
	eFileTypes GetFileType( CString file );

	/** */
	CList<DCConfigShareFolder> m_SharedFolders;
	/** */
	DCConfigShareFolder * m_pShareFolder;
	/** */
	ulonglong m_nFileBaseIndex;
	/** */
	CString m_sShareIndexBuffer;
	/** */
	ulonglong m_nShareSize;

	/** */
	time_t m_tCreateShareListTimeout;

	/** */
	CFileManagerInfo * m_pFileManagerInfo;
	/** */
	_CCallback * m_pFileManagerCallback;

	/** search index class */
	CSearchIndex * m_pSearchIndex;
	/** sharelist class */
	CShareList * m_pShareList;
	/** */
	CByteArray * m_pHashMemory;
};

#endif
