/* 
 * pic18f4331.h - device specific declarations
 *
 * This file is part of the GNU PIC library for SDCC,
 * originally devised by Vangelis Rokas <vrokas AT otenet.gr>
 *
 * It has been automatically generated by inc2h-pic16.pl,
 * (c) 2007 by Raphael Neider <rneider AT web.de>
 */

#ifndef __PIC18F4331_H__
#define __PIC18F4331_H__ 1



// Configuration Bits
#define	__CONFIG1H           	0x300001
#define	__CONFIG2L           	0x300002
#define	__CONFIG2H           	0x300003
#define	__CONFIG3L           	0x300004
#define	__CONFIG3H           	0x300005
#define	__CONFIG4L           	0x300006
#define	__CONFIG5L           	0x300008
#define	__CONFIG5H           	0x300009
#define	__CONFIG6L           	0x30000A
#define	__CONFIG6H           	0x30000B
#define	__CONFIG7L           	0x30000C
#define	__CONFIG7H           	0x30000D

// CONFIG1H Options
#define	_OSC_LP_1H          	0xF0	 // LP
#define	_OSC_XT_1H          	0xF1	 // XT
#define	_OSC_HS_1H          	0xF2	 // HS
#define	_OSC_RC2_1H         	0xF3	 // External RC, RA6 is CLKOUT
#define	_OSC_EC_1H          	0xF4	 // EC, RA6 is CLKOUT
#define	_OSC_ECIO_1H        	0xF5	 // EC, RA6 is I/O
#define	_OSC_HSPLL_1H       	0xF6	 // HS-PLL Enabled
#define	_OSC_RCIO_1H        	0xF7	 // External RC, RA6 is I/O
#define	_OSC_IRCIO_1H       	0xF8	 // Internal RC, RA6 & RA7 are I/O
#define	_OSC_IRC_1H         	0xF9	 // Internal RC, RA6 is CLKOUT, RA7 is I/O
#define	_OSC_RC1_1H         	0xFB	 // External RC, RA6 is CLKOUT
#define	_OSC_RC_1H          	0xFF	 // External RC, RA6 is CLKOUT
#define	_FCMEN_OFF_1H       	0xBF	 // Disabled
#define	_FCMEN_ON_1H        	0xFF	 // Enabled
#define	_IESO_OFF_1H        	0x7F	 // Disabled
#define	_IESO_ON_1H         	0xFF	 // Enabled

// CONFIG2L Options
#define	_PWRTEN_ON_2L       	0xFE	 // Enabled
#define	_PWRTEN_OFF_2L      	0xFF	 // Disabled
#define	_BOREN_OFF_2L       	0xFD	 // Disabled
#define	_BOREN_ON_2L        	0xFF	 // Enabled
#define	_BORV_45_2L         	0xF3	 // 4.5V
#define	_BORV_42_2L         	0xF7	 // 4.2V
#define	_BORV_27_2L         	0xFB	 // 2.7V
#define	_BORV_20_2L         	0xFF	 // 2.0V

// CONFIG2H Options
#define	_WDTEN_OFF_2H       	0xFE	 // Disabled
#define	_WDTEN_ON_2H        	0xFF	 // Enabled
#define	_WINEN_ON_2H        	0xDF	 // Enabled
#define	_WINEN_OFF_2H       	0xFF	 // Disabled
#define	_WDPS_1_2H          	0xE1	 // 1:1
#define	_WDPS_2_2H          	0xE3	 // 1:2
#define	_WDPS_4_2H          	0xE5	 // 1:4
#define	_WDPS_8_2H          	0xE7	 // 1:8
#define	_WDPS_16_2H         	0xE9	 // 1:16
#define	_WDPS_32_2H         	0xEB	 // 1:32
#define	_WDPS_64_2H         	0xED	 // 1:64
#define	_WDPS_128_2H        	0xEF	 // 1:128
#define	_WDPS_256_2H        	0xF1	 // 1:256
#define	_WDPS_512_2H        	0xF3	 // 1:512
#define	_WDPS_1024_2H       	0xF5	 // 1:1024
#define	_WDPS_2048_2H       	0xF7	 // 1:2048
#define	_WDPS_4096_2H       	0xF9	 // 1:4096
#define	_WDPS_8192_2H       	0xFB	 // 1:8192
#define	_WDPS_16384_2H      	0xFD	 // 1:16384
#define	_WDPS_32768_2H      	0xFF	 // 1:32768

// CONFIG3L Options
#define	_T1OSCMX_OFF_3L     	0xDF	 // Active
#define	_T1OSCMX_ON_3L      	0xFF	 // Inactive
#define	_HPOL_LOW_3L        	0xEF	 // Active low
#define	_HPOL_HIGH_3L       	0xFF	 // Active high
#define	_LPOL_LOW_3L        	0xF7	 // Active low
#define	_LPOL_HIGH_3L       	0xFF	 // Active high
#define	_PWMPIN_ON_3L       	0xFB	 // Enabled
#define	_PWMPIN_OFF_3L      	0xFF	 // Disabled

// CONFIG3H Options
#define	_MCLRE_OFF_3H       	0x7F	 // Disabled
#define	_MCLRE_ON_3H        	0xFF	 // Enabled
#define	_EXCLKMX_RD0_3H     	0xEF	 // Multiplexed with RD0
#define	_EXCLKMX_RC3_3H     	0xFF	 // Multiplexed with RC3
#define	_PWM4MX_RD5_3H      	0xF7	 // Multiplexed with RD5
#define	_PWM4MX_RB5_3H      	0xFF	 // Multiplexed with RB5
#define	_SSPMX_RD1_3H       	0xFB	 // SDO output is multiplexed with RD1
#define	_SSPMX_RC7_3H       	0xFF	 // SD0 output is multiplexed with RC7
#define	_FLTAMX_RD4_3H      	0xFE	 // Multiplexed with RD4
#define	_FLTAMX_RC1_3H      	0xFF	 // Multiplexed with RC1

// CONFIG4L Options
#define	_STVREN_OFF_4L      	0xFE	 // Disabled
#define	_STVREN_ON_4L       	0xFF	 // Enabled
#define	_LVP_OFF_4L         	0xFB	 // Disabled
#define	_LVP_ON_4L          	0xFF	 // Enabled
#define	_DEBUG_ON_4L        	0x7F	 // Enabled
#define	_DEBUG_OFF_4L       	0xFF	 // Disabled

// CONFIG5L Options
#define	_CP0_ON_5L          	0xFE	 // Enabled
#define	_CP0_OFF_5L         	0xFF	 // Disabled
#define	_CP1_ON_5L          	0xFD	 // Enabled
#define	_CP1_OFF_5L         	0xFF	 // Disabled
#define	_CP2_ON_5L          	0xFB	 // Enabled
#define	_CP2_OFF_5L         	0xFF	 // Disabled
#define	_CP3_ON_5L          	0xF7	 // Enabled
#define	_CP3_OFF_5L         	0xFF	 // Disabled

// CONFIG5H Options
#define	_CPB_ON_5H          	0xBF	 // Enabled
#define	_CPB_OFF_5H         	0xFF	 // Disabled
#define	_CPD_ON_5H          	0x7F	 // Enabled
#define	_CPD_OFF_5H         	0xFF	 // Disabled

// CONFIG6L Options
#define	_WRT0_ON_6L         	0xFE	 // Enabled
#define	_WRT0_OFF_6L        	0xFF	 // Disabled
#define	_WRT1_ON_6L         	0xFD	 // Enabled
#define	_WRT1_OFF_6L        	0xFF	 // Disabled
#define	_WRT2_ON_6L         	0xFB	 // Enabled
#define	_WRT2_OFF_6L        	0xFF	 // Disabled
#define	_WRT3_ON_6L         	0xF7	 // Enabled
#define	_WRT3_OFF_6L        	0xFF	 // Disabled

// CONFIG6H Options
#define	_WRTB_ON_6H         	0xBF	 // Enabled
#define	_WRTB_OFF_6H        	0xFF	 // Disabled
#define	_WRTC_ON_6H         	0xDF	 // Enabled
#define	_WRTC_OFF_6H        	0xFF	 // Disabled
#define	_WRTD_ON_6H         	0x7F	 // Enabled
#define	_WRTD_OFF_6H        	0xFF	 // Disabled

// CONFIG7L Options
#define	_EBTR0_ON_7L        	0xFE	 // Enabled
#define	_EBTR0_OFF_7L       	0xFF	 // Disabled
#define	_EBTR1_ON_7L        	0xFD	 // Enabled
#define	_EBTR1_OFF_7L       	0xFF	 // Disabled
#define	_EBTR2_ON_7L        	0xFB	 // Enabled
#define	_EBTR2_OFF_7L       	0xFF	 // Disabled
#define	_EBTR3_ON_7L        	0xF7	 // Enabled
#define	_EBTR3_OFF_7L       	0xFF	 // Disabled

// CONFIG7H Options
#define	_EBTRB_ON_7H        	0xBF	 // Enabled
#define	_EBTRB_OFF_7H       	0xFF	 // Disabled
#define	_DEVID1             	0x3FFFFE
#define	_DEVID2             	0x3FFFFF
#define	_IDLOC0             	0x200000
#define	_IDLOC1             	0x200001
#define	_IDLOC2             	0x200002
#define	_IDLOC3             	0x200003
#define	_IDLOC4             	0x200004
#define	_IDLOC5             	0x200005
#define	_IDLOC6             	0x200006
#define	_IDLOC7             	0x200007

extern __sfr __at (0xF60) DFLTCON;
typedef union {
	struct {
		unsigned FLTCK0    	: 1;
		unsigned FLTCK1    	: 1;
		unsigned FLTCK2    	: 1;
		unsigned FLT1EN    	: 1;
		unsigned FLT2EN    	: 1;
		unsigned FLT3EN    	: 1;
		unsigned FLT4EN    	: 1;
		unsigned           	: 1;
	};
} __DFLTCONbits_t;
extern volatile __DFLTCONbits_t __at (0xF60) DFLTCONbits;

extern __sfr __at (0xF61) CAP3CON;
typedef union {
	struct {
		unsigned CAP3M0    	: 1;
		unsigned CAP3M1    	: 1;
		unsigned CAP3M2    	: 1;
		unsigned CAP3M3    	: 1;
		unsigned           	: 1;
		unsigned CAP3TMR   	: 1;
		unsigned CAP3REN   	: 1;
		unsigned           	: 1;
	};
} __CAP3CONbits_t;
extern volatile __CAP3CONbits_t __at (0xF61) CAP3CONbits;

extern __sfr __at (0xF62) CAP2CON;
typedef union {
	struct {
		unsigned CAP2M0    	: 1;
		unsigned CAP2M1    	: 1;
		unsigned CAP2M2    	: 1;
		unsigned CAP2M3    	: 1;
		unsigned           	: 1;
		unsigned CAP2TMR   	: 1;
		unsigned CAP2REN   	: 1;
		unsigned           	: 1;
	};
} __CAP2CONbits_t;
extern volatile __CAP2CONbits_t __at (0xF62) CAP2CONbits;

extern __sfr __at (0xF63) CAP1CON;
typedef union {
	struct {
		unsigned CAP1M0    	: 1;
		unsigned CAP1M1    	: 1;
		unsigned CAP1M2    	: 1;
		unsigned CAP1M3    	: 1;
		unsigned           	: 1;
		unsigned CAP1TMR   	: 1;
		unsigned CAP1REN   	: 1;
		unsigned           	: 1;
	};
} __CAP1CONbits_t;
extern volatile __CAP1CONbits_t __at (0xF63) CAP1CONbits;

extern __sfr __at (0xF64) CAP3BUFL;

extern __sfr __at (0xF64) MAXCNTL;

extern __sfr __at (0xF65) CAP3BUFH;

extern __sfr __at (0xF65) MAXCNTH;

extern __sfr __at (0xF66) CAP2BUFL;

extern __sfr __at (0xF66) POSCNTL;

extern __sfr __at (0xF67) CAP2BUFH;

extern __sfr __at (0xF67) POSCNTH;

extern __sfr __at (0xF68) CAP1BUFL;

extern __sfr __at (0xF68) VELRL;

extern __sfr __at (0xF69) CAP1BUFH;

extern __sfr __at (0xF69) VELRH;

extern __sfr __at (0xF6A) OVDCONS;
typedef union {
	struct {
		unsigned POUT0     	: 1;
		unsigned POUT1     	: 1;
		unsigned POUT2     	: 1;
		unsigned POUT3     	: 1;
		unsigned POUT4     	: 1;
		unsigned POUT5     	: 1;
		unsigned POUT6     	: 1;
		unsigned POUT7     	: 1;
	};
} __OVDCONSbits_t;
extern volatile __OVDCONSbits_t __at (0xF6A) OVDCONSbits;

extern __sfr __at (0xF6B) OVDCOND;
typedef union {
	struct {
		unsigned POVD0     	: 1;
		unsigned POVD1     	: 1;
		unsigned POVD2     	: 1;
		unsigned POVD3     	: 1;
		unsigned POVD4     	: 1;
		unsigned POVD5     	: 1;
		unsigned POVD6     	: 1;
		unsigned POVD7     	: 1;
	};
} __OVDCONDbits_t;
extern volatile __OVDCONDbits_t __at (0xF6B) OVDCONDbits;

extern __sfr __at (0xF6C) FLTCONFIG;
typedef union {
	struct {
		unsigned FLTAEN    	: 1;
		unsigned FLTAMOD   	: 1;
		unsigned FLTAS     	: 1;
		unsigned FLTCON    	: 1;
		unsigned FLTBEN    	: 1;
		unsigned FLTBMOD   	: 1;
		unsigned FLTBS     	: 1;
		unsigned           	: 1;
	};
} __FLTCONFIGbits_t;
extern volatile __FLTCONFIGbits_t __at (0xF6C) FLTCONFIGbits;

extern __sfr __at (0xF6D) DTCON;
typedef union {
	struct {
		unsigned DT0       	: 1;
		unsigned DT1       	: 1;
		unsigned DT2       	: 1;
		unsigned DT3       	: 1;
		unsigned DT4       	: 1;
		unsigned DT5       	: 1;
		unsigned DTPS0     	: 1;
		unsigned DTPS1     	: 1;
	};
	struct {
		unsigned DTA0      	: 1;
		unsigned DTA1      	: 1;
		unsigned DTA2      	: 1;
		unsigned DTA3      	: 1;
		unsigned DTA4      	: 1;
		unsigned DTA5      	: 1;
		unsigned DTAPS0    	: 1;
		unsigned DTAPS1    	: 1;
	};
} __DTCONbits_t;
extern volatile __DTCONbits_t __at (0xF6D) DTCONbits;

extern __sfr __at (0xF6E) PWMCON1;
typedef union {
	struct {
		unsigned OSYNC     	: 1;
		unsigned UDIS      	: 1;
		unsigned           	: 1;
		unsigned SEVTDIR   	: 1;
		unsigned SEVOPS0   	: 1;
		unsigned SEVOPS1   	: 1;
		unsigned SEVOPS2   	: 1;
		unsigned SEVOPS3   	: 1;
	};
} __PWMCON1bits_t;
extern volatile __PWMCON1bits_t __at (0xF6E) PWMCON1bits;

extern __sfr __at (0xF6F) PWMCON0;
typedef union {
	struct {
		unsigned PMOD0     	: 1;
		unsigned PMOD1     	: 1;
		unsigned PMOD2     	: 1;
		unsigned PMOD3     	: 1;
		unsigned PWMEN0    	: 1;
		unsigned PWMEN1    	: 1;
		unsigned PWMEN2    	: 1;
		unsigned           	: 1;
	};
} __PWMCON0bits_t;
extern volatile __PWMCON0bits_t __at (0xF6F) PWMCON0bits;

extern __sfr __at (0xF70) SEVTCMPH;

extern __sfr __at (0xF71) SEVTCMPL;

extern __sfr __at (0xF72) PDC3H;

extern __sfr __at (0xF73) PDC3L;

extern __sfr __at (0xF74) PDC2H;

extern __sfr __at (0xF75) PDC2L;

extern __sfr __at (0xF76) PDC1H;

extern __sfr __at (0xF77) PDC1L;

extern __sfr __at (0xF78) PDC0H;

extern __sfr __at (0xF79) PDC0L;

extern __sfr __at (0xF7A) PTPERH;

extern __sfr __at (0xF7B) PTPERL;

extern __sfr __at (0xF7C) PTMRH;

extern __sfr __at (0xF7D) PTMRL;

extern __sfr __at (0xF7E) PTCON1;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned PTDIR     	: 1;
		unsigned PTEN      	: 1;
	};
} __PTCON1bits_t;
extern volatile __PTCON1bits_t __at (0xF7E) PTCON1bits;

extern __sfr __at (0xF7F) PTCON0;
typedef union {
	struct {
		unsigned PTMOD0    	: 1;
		unsigned PTMOD1    	: 1;
		unsigned PTCKPS0   	: 1;
		unsigned PTCKPS1   	: 1;
		unsigned PTOPS0    	: 1;
		unsigned PTOPS1    	: 1;
		unsigned PTOPS2    	: 1;
		unsigned PTOPS3    	: 1;
	};
} __PTCON0bits_t;
extern volatile __PTCON0bits_t __at (0xF7F) PTCON0bits;

extern __sfr __at (0xF80) PORTA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned RA7       	: 1;
	};
	struct {
		unsigned AN0       	: 1;
		unsigned AN1       	: 1;
		unsigned AN2       	: 1;
		unsigned AN3       	: 1;
		unsigned AN4       	: 1;
		unsigned AN5       	: 1;
		unsigned OSC2      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned VREFM     	: 1;
		unsigned VREFP     	: 1;
		unsigned           	: 1;
		unsigned LVDIN     	: 1;
		unsigned CLKO      	: 1;
		unsigned           	: 1;
	};
} __PORTAbits_t;
extern volatile __PORTAbits_t __at (0xF80) PORTAbits;

extern __sfr __at (0xF81) PORTB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
} __PORTBbits_t;
extern volatile __PORTBbits_t __at (0xF81) PORTBbits;

extern __sfr __at (0xF82) PORTC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
	struct {
		unsigned T1OSO     	: 1;
		unsigned T1OSI     	: 1;
		unsigned CCP1      	: 1;
		unsigned INT0      	: 1;
		unsigned INT1      	: 1;
		unsigned INT2      	: 1;
		unsigned TX        	: 1;
		unsigned RX        	: 1;
	};
	struct {
		unsigned T13CKI    	: 1;
		unsigned CCP2      	: 1;
		unsigned NOT_FLTB  	: 1;
		unsigned T0CKI     	: 1;
		unsigned SDA       	: 1;
		unsigned SCK       	: 1;
		unsigned CK        	: 1;
		unsigned DT        	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_FLTA  	: 1;
		unsigned FLTB      	: 1;
		unsigned T5CKI     	: 1;
		unsigned SDI       	: 1;
		unsigned SCL       	: 1;
		unsigned NOT_SS    	: 1;
		unsigned SDO       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned FLTA      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SS        	: 1;
		unsigned           	: 1;
	};
} __PORTCbits_t;
extern volatile __PORTCbits_t __at (0xF82) PORTCbits;

extern __sfr __at (0xF83) PORTD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned RD3       	: 1;
		unsigned RD4       	: 1;
		unsigned RD5       	: 1;
		unsigned RD6       	: 1;
		unsigned RD7       	: 1;
	};
} __PORTDbits_t;
extern volatile __PORTDbits_t __at (0xF83) PORTDbits;

extern __sfr __at (0xF84) PORTE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned RE3       	: 1;
		unsigned RE4       	: 1;
		unsigned RE5       	: 1;
		unsigned RE6       	: 1;
		unsigned RE7       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_MCLR  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned MCLR      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTEbits_t;
extern volatile __PORTEbits_t __at (0xF84) PORTEbits;

extern __sfr __at (0xF87) TMR5L;

extern __sfr __at (0xF88) TMR5H;

extern __sfr __at (0xF89) LATA;
typedef union {
	struct {
		unsigned LATA0     	: 1;
		unsigned LATA1     	: 1;
		unsigned LATA2     	: 1;
		unsigned LATA3     	: 1;
		unsigned LATA4     	: 1;
		unsigned LATA5     	: 1;
		unsigned LATA6     	: 1;
		unsigned LATA7     	: 1;
	};
} __LATAbits_t;
extern volatile __LATAbits_t __at (0xF89) LATAbits;

extern __sfr __at (0xF8A) LATB;
typedef union {
	struct {
		unsigned LATB0     	: 1;
		unsigned LATB1     	: 1;
		unsigned LATB2     	: 1;
		unsigned LATB3     	: 1;
		unsigned LATB4     	: 1;
		unsigned LATB5     	: 1;
		unsigned LATB6     	: 1;
		unsigned LATB7     	: 1;
	};
} __LATBbits_t;
extern volatile __LATBbits_t __at (0xF8A) LATBbits;

extern __sfr __at (0xF8B) LATC;
typedef union {
	struct {
		unsigned LATC0     	: 1;
		unsigned LATC1     	: 1;
		unsigned LATC2     	: 1;
		unsigned LATC3     	: 1;
		unsigned LATC4     	: 1;
		unsigned LATC5     	: 1;
		unsigned LATC6     	: 1;
		unsigned LATC7     	: 1;
	};
} __LATCbits_t;
extern volatile __LATCbits_t __at (0xF8B) LATCbits;

extern __sfr __at (0xF8C) LATD;
typedef union {
	struct {
		unsigned LATD0     	: 1;
		unsigned LATD1     	: 1;
		unsigned LATD2     	: 1;
		unsigned LATD3     	: 1;
		unsigned LATD4     	: 1;
		unsigned LATD5     	: 1;
		unsigned LATD6     	: 1;
		unsigned LATD7     	: 1;
	};
} __LATDbits_t;
extern volatile __LATDbits_t __at (0xF8C) LATDbits;

extern __sfr __at (0xF8D) LATE;
typedef union {
	struct {
		unsigned LATE0     	: 1;
		unsigned LATE1     	: 1;
		unsigned LATE2     	: 1;
		unsigned LATE3     	: 1;
		unsigned LATE4     	: 1;
		unsigned LATE5     	: 1;
		unsigned LATE6     	: 1;
		unsigned LATE7     	: 1;
	};
} __LATEbits_t;
extern volatile __LATEbits_t __at (0xF8D) LATEbits;

extern __sfr __at (0xF90) PR5L;

extern __sfr __at (0xF91) PR5H;

extern __sfr __at (0xF92) DDRA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned RA7       	: 1;
	};
} __DDRAbits_t;
extern volatile __DDRAbits_t __at (0xF92) DDRAbits;

extern __sfr __at (0xF92) TRISA;
typedef union {
	struct {
		unsigned TRISA0    	: 1;
		unsigned TRISA1    	: 1;
		unsigned TRISA2    	: 1;
		unsigned TRISA3    	: 1;
		unsigned TRISA4    	: 1;
		unsigned TRISA5    	: 1;
		unsigned TRISA6    	: 1;
		unsigned TRISA7    	: 1;
	};
} __TRISAbits_t;
extern volatile __TRISAbits_t __at (0xF92) TRISAbits;

extern __sfr __at (0xF93) DDRB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
} __DDRBbits_t;
extern volatile __DDRBbits_t __at (0xF93) DDRBbits;

extern __sfr __at (0xF93) TRISB;
typedef union {
	struct {
		unsigned TRISB0    	: 1;
		unsigned TRISB1    	: 1;
		unsigned TRISB2    	: 1;
		unsigned TRISB3    	: 1;
		unsigned TRISB4    	: 1;
		unsigned TRISB5    	: 1;
		unsigned TRISB6    	: 1;
		unsigned TRISB7    	: 1;
	};
} __TRISBbits_t;
extern volatile __TRISBbits_t __at (0xF93) TRISBbits;

extern __sfr __at (0xF94) DDRC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
} __DDRCbits_t;
extern volatile __DDRCbits_t __at (0xF94) DDRCbits;

extern __sfr __at (0xF94) TRISC;
typedef union {
	struct {
		unsigned TRISC0    	: 1;
		unsigned TRISC1    	: 1;
		unsigned TRISC2    	: 1;
		unsigned TRISC3    	: 1;
		unsigned TRISC4    	: 1;
		unsigned TRISC5    	: 1;
		unsigned TRISC6    	: 1;
		unsigned TRISC7    	: 1;
	};
} __TRISCbits_t;
extern volatile __TRISCbits_t __at (0xF94) TRISCbits;

extern __sfr __at (0xF95) DDRD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned RD3       	: 1;
		unsigned RD4       	: 1;
		unsigned RD5       	: 1;
		unsigned RD6       	: 1;
		unsigned RD7       	: 1;
	};
} __DDRDbits_t;
extern volatile __DDRDbits_t __at (0xF95) DDRDbits;

extern __sfr __at (0xF95) TRISD;
typedef union {
	struct {
		unsigned TRISD0    	: 1;
		unsigned TRISD1    	: 1;
		unsigned TRISD2    	: 1;
		unsigned TRISD3    	: 1;
		unsigned TRISD4    	: 1;
		unsigned TRISD5    	: 1;
		unsigned TRISD6    	: 1;
		unsigned TRISD7    	: 1;
	};
} __TRISDbits_t;
extern volatile __TRISDbits_t __at (0xF95) TRISDbits;

extern __sfr __at (0xF96) DDRE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned RE3       	: 1;
		unsigned RE4       	: 1;
		unsigned RE5       	: 1;
		unsigned RE6       	: 1;
		unsigned RE7       	: 1;
	};
} __DDREbits_t;
extern volatile __DDREbits_t __at (0xF96) DDREbits;

extern __sfr __at (0xF96) TRISE;
typedef union {
	struct {
		unsigned TRISE0    	: 1;
		unsigned TRISE1    	: 1;
		unsigned TRISE2    	: 1;
		unsigned TRISE3    	: 1;
		unsigned TRISE4    	: 1;
		unsigned TRISE5    	: 1;
		unsigned TRISE6    	: 1;
		unsigned TRISE7    	: 1;
	};
} __TRISEbits_t;
extern volatile __TRISEbits_t __at (0xF96) TRISEbits;

extern __sfr __at (0xF99) ADCHS;
typedef union {
	struct {
		unsigned GASEL0    	: 1;
		unsigned GASEL1    	: 1;
		unsigned GCSEL0    	: 1;
		unsigned GCSEL1    	: 1;
		unsigned GBSEL0    	: 1;
		unsigned GBSEL1    	: 1;
		unsigned GDSEL0    	: 1;
		unsigned GDSEL1    	: 1;
	};
	struct {
		unsigned SASEL0    	: 1;
		unsigned SASEL1    	: 1;
		unsigned SCSEL0    	: 1;
		unsigned SCSEL1    	: 1;
		unsigned SBSEL0    	: 1;
		unsigned SBSEL1    	: 1;
		unsigned SDSEL0    	: 1;
		unsigned SDSEL1    	: 1;
	};
} __ADCHSbits_t;
extern volatile __ADCHSbits_t __at (0xF99) ADCHSbits;

extern __sfr __at (0xF9A) ADCON3;
typedef union {
	struct {
		unsigned SSRC0     	: 1;
		unsigned SSRC1     	: 1;
		unsigned SSRC2     	: 1;
		unsigned SSRC3     	: 1;
		unsigned SSRC4     	: 1;
		unsigned           	: 1;
		unsigned ADRS0     	: 1;
		unsigned ADRS1     	: 1;
	};
} __ADCON3bits_t;
extern volatile __ADCON3bits_t __at (0xF9A) ADCON3bits;

extern __sfr __at (0xF9B) OSCTUNE;
typedef union {
	struct {
		unsigned TUN0      	: 1;
		unsigned TUN1      	: 1;
		unsigned TUN2      	: 1;
		unsigned TUN3      	: 1;
		unsigned TUN4      	: 1;
		unsigned TUN5      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __OSCTUNEbits_t;
extern volatile __OSCTUNEbits_t __at (0xF9B) OSCTUNEbits;

extern __sfr __at (0xF9D) PIE1;
typedef union {
	struct {
		unsigned TMR1IE    	: 1;
		unsigned TMR2IE    	: 1;
		unsigned CCP1IE    	: 1;
		unsigned SSPIE     	: 1;
		unsigned TBIE      	: 1;
		unsigned RCIE      	: 1;
		unsigned ADIE      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXIE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE1bits_t;
extern volatile __PIE1bits_t __at (0xF9D) PIE1bits;

extern __sfr __at (0xF9E) PIR1;
typedef union {
	struct {
		unsigned TMR1IF    	: 1;
		unsigned TMR2IF    	: 1;
		unsigned CCP1IF    	: 1;
		unsigned SSPIF     	: 1;
		unsigned TBIF      	: 1;
		unsigned RCIF      	: 1;
		unsigned ADIF      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXIF      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR1bits_t;
extern volatile __PIR1bits_t __at (0xF9E) PIR1bits;

extern __sfr __at (0xF9F) IPR1;
typedef union {
	struct {
		unsigned TMR1IP    	: 1;
		unsigned TMR2IP    	: 1;
		unsigned CCP1IP    	: 1;
		unsigned SSPIP     	: 1;
		unsigned TBIP      	: 1;
		unsigned RCIP      	: 1;
		unsigned ADIP      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXIP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR1bits_t;
extern volatile __IPR1bits_t __at (0xF9F) IPR1bits;

extern __sfr __at (0xFA0) PIE2;
typedef union {
	struct {
		unsigned CCP2IE    	: 1;
		unsigned           	: 1;
		unsigned LVDIE     	: 1;
		unsigned           	: 1;
		unsigned EEIE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OSFIE     	: 1;
	};
} __PIE2bits_t;
extern volatile __PIE2bits_t __at (0xFA0) PIE2bits;

extern __sfr __at (0xFA1) PIR2;
typedef union {
	struct {
		unsigned CCP2IF    	: 1;
		unsigned           	: 1;
		unsigned LVDIF     	: 1;
		unsigned           	: 1;
		unsigned EEIF      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OSFIF     	: 1;
	};
} __PIR2bits_t;
extern volatile __PIR2bits_t __at (0xFA1) PIR2bits;

extern __sfr __at (0xFA2) IPR2;
typedef union {
	struct {
		unsigned CCP2IP    	: 1;
		unsigned           	: 1;
		unsigned LVDIP     	: 1;
		unsigned           	: 1;
		unsigned EEIP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OSFIP     	: 1;
	};
} __IPR2bits_t;
extern volatile __IPR2bits_t __at (0xFA2) IPR2bits;

extern __sfr __at (0xFA3) PIE3;
typedef union {
	struct {
		unsigned TMR5IE    	: 1;
		unsigned IC1IE     	: 1;
		unsigned IC2QEIE   	: 1;
		unsigned IC3DRIE   	: 1;
		unsigned PTIE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE3bits_t;
extern volatile __PIE3bits_t __at (0xFA3) PIE3bits;

extern __sfr __at (0xFA4) PIR3;
typedef union {
	struct {
		unsigned TMR5IF    	: 1;
		unsigned IC1IF     	: 1;
		unsigned IC2QEIF   	: 1;
		unsigned IC3DRIF   	: 1;
		unsigned PTIF      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR3bits_t;
extern volatile __PIR3bits_t __at (0xFA4) PIR3bits;

extern __sfr __at (0xFA5) IPR3;
typedef union {
	struct {
		unsigned TMR5IP    	: 1;
		unsigned IC1IP     	: 1;
		unsigned IC2QEIP   	: 1;
		unsigned IC3DRIP   	: 1;
		unsigned PTIP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR3bits_t;
extern volatile __IPR3bits_t __at (0xFA5) IPR3bits;

extern __sfr __at (0xFA6) EECON1;
typedef union {
	struct {
		unsigned RD        	: 1;
		unsigned WR        	: 1;
		unsigned WREN      	: 1;
		unsigned WRERR     	: 1;
		unsigned FREE      	: 1;
		unsigned           	: 1;
		unsigned CFGS      	: 1;
		unsigned EEPGD     	: 1;
	};
} __EECON1bits_t;
extern volatile __EECON1bits_t __at (0xFA6) EECON1bits;

extern __sfr __at (0xFA7) EECON2;

extern __sfr __at (0xFA8) EEDATA;

extern __sfr __at (0xFA9) EEADR;

extern __sfr __at (0xFAA) BAUDCON;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCONbits_t;
extern volatile __BAUDCONbits_t __at (0xFAA) BAUDCONbits;

extern __sfr __at (0xFAA) BAUDCTL;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCTLbits_t;
extern volatile __BAUDCTLbits_t __at (0xFAA) BAUDCTLbits;

extern __sfr __at (0xFAB) RCSTA;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADEN      	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
} __RCSTAbits_t;
extern volatile __RCSTAbits_t __at (0xFAB) RCSTAbits;

extern __sfr __at (0xFAC) TXSTA;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
} __TXSTAbits_t;
extern volatile __TXSTAbits_t __at (0xFAC) TXSTAbits;

extern __sfr __at (0xFAD) TXREG;

extern __sfr __at (0xFAE) RCREG;

extern __sfr __at (0xFAF) SPBRG;

extern __sfr __at (0xFB0) SPBRGH;

extern __sfr __at (0xFB6) QEICON;
typedef union {
	struct {
		unsigned PDEC0     	: 1;
		unsigned PDEC1     	: 1;
		unsigned QEIM0     	: 1;
		unsigned QEIM1     	: 1;
		unsigned QEIM2     	: 1;
		unsigned UP_DOWN   	: 1;
		unsigned ERROR     	: 1;
		unsigned VELM      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned UP        	: 1;
		unsigned           	: 1;
		unsigned NOT_VELM  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DOWN      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_DOWN  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __QEICONbits_t;
extern volatile __QEICONbits_t __at (0xFB6) QEICONbits;

extern __sfr __at (0xFB7) T5CON;
typedef union {
	struct {
		unsigned TMR5ON    	: 1;
		unsigned TMR5CS    	: 1;
		unsigned T5SYNC    	: 1;
		unsigned T5PS0     	: 1;
		unsigned T5PS1     	: 1;
		unsigned T5MOD     	: 1;
		unsigned RESEN     	: 1;
		unsigned T5SEN     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T5SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RESEN 	: 1;
		unsigned           	: 1;
	};
} __T5CONbits_t;
extern volatile __T5CONbits_t __at (0xFB7) T5CONbits;

extern __sfr __at (0xFB8) ANSEL0;
typedef union {
	struct {
		unsigned ANS0      	: 1;
		unsigned ANS1      	: 1;
		unsigned ANS2      	: 1;
		unsigned ANS3      	: 1;
		unsigned ANS4      	: 1;
		unsigned ANS5      	: 1;
		unsigned ANS6      	: 1;
		unsigned ANS7      	: 1;
	};
} __ANSEL0bits_t;
extern volatile __ANSEL0bits_t __at (0xFB8) ANSEL0bits;

extern __sfr __at (0xFB9) ANSEL1;
typedef union {
	struct {
		unsigned ANS8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ANSEL1bits_t;
extern volatile __ANSEL1bits_t __at (0xFB9) ANSEL1bits;

extern __sfr __at (0xFBA) CCP2CON;
typedef union {
	struct {
		unsigned CCP2M0    	: 1;
		unsigned CCP2M1    	: 1;
		unsigned CCP2M2    	: 1;
		unsigned CCP2M3    	: 1;
		unsigned CCP2Y     	: 1;
		unsigned CCP2X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DC2B0     	: 1;
		unsigned DC2B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP2CONbits_t;
extern volatile __CCP2CONbits_t __at (0xFBA) CCP2CONbits;

extern __sfr __at (0xFBB) CCPR2;

extern __sfr __at (0xFBB) CCPR2L;

extern __sfr __at (0xFBC) CCPR2H;

extern __sfr __at (0xFBD) CCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned CCP1Y     	: 1;
		unsigned CCP1X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP1CONbits_t;
extern volatile __CCP1CONbits_t __at (0xFBD) CCP1CONbits;

extern __sfr __at (0xFBE) CCPR1;

extern __sfr __at (0xFBE) CCPR1L;

extern __sfr __at (0xFBF) CCPR1H;

extern __sfr __at (0xFC0) ADCON2;
typedef union {
	struct {
		unsigned ADCS0     	: 1;
		unsigned ADCS1     	: 1;
		unsigned ADCS2     	: 1;
		unsigned ACQT0     	: 1;
		unsigned ACQT1     	: 1;
		unsigned ACQT2     	: 1;
		unsigned ACQT3     	: 1;
		unsigned ADFM      	: 1;
	};
} __ADCON2bits_t;
extern volatile __ADCON2bits_t __at (0xFC0) ADCON2bits;

extern __sfr __at (0xFC1) ADCON1;
typedef union {
	struct {
		unsigned ADPNT0    	: 1;
		unsigned ADPNT1    	: 1;
		unsigned BFOVFL    	: 1;
		unsigned BFEMT     	: 1;
		unsigned FIFOEN    	: 1;
		unsigned           	: 1;
		unsigned VCFG0     	: 1;
		unsigned VCFG1     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned FFOVFL    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON1bits_t;
extern volatile __ADCON1bits_t __at (0xFC1) ADCON1bits;

extern __sfr __at (0xFC2) ADCON0;
typedef union {
	struct {
		unsigned ADON      	: 1;
		unsigned GO_DONE   	: 1;
		unsigned ACMOD0    	: 1;
		unsigned ACMOD1    	: 1;
		unsigned ACSCH     	: 1;
		unsigned ACONV     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned DONE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_DONE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON0bits_t;
extern volatile __ADCON0bits_t __at (0xFC2) ADCON0bits;

extern __sfr __at (0xFC3) ADRES;

extern __sfr __at (0xFC3) ADRESL;

extern __sfr __at (0xFC4) ADRESH;

extern __sfr __at (0xFC6) SSPCON;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSPCONbits_t;
extern volatile __SSPCONbits_t __at (0xFC6) SSPCONbits;

extern __sfr __at (0xFC7) SSPSTAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_W       	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_A       	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPSTATbits_t;
extern volatile __SSPSTATbits_t __at (0xFC7) SSPSTATbits;

extern __sfr __at (0xFC8) SSPADD;

extern __sfr __at (0xFC9) SSPBUF;

extern __sfr __at (0xFCA) T2CON;
typedef union {
	struct {
		unsigned T2CKPS0   	: 1;
		unsigned T2CKPS1   	: 1;
		unsigned TMR2ON    	: 1;
		unsigned T2OUTPS0  	: 1;
		unsigned T2OUTPS1  	: 1;
		unsigned T2OUTPS2  	: 1;
		unsigned T2OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T2CONbits_t;
extern volatile __T2CONbits_t __at (0xFCA) T2CONbits;

extern __sfr __at (0xFCB) PR2;

extern __sfr __at (0xFCC) TMR2;

extern __sfr __at (0xFCD) T1CON;
typedef union {
	struct {
		unsigned TMR1ON    	: 1;
		unsigned TMR1CS    	: 1;
		unsigned T1SYNC    	: 1;
		unsigned T1OSCEN   	: 1;
		unsigned T1CKPS0   	: 1;
		unsigned T1CKPS1   	: 1;
		unsigned T1RUN     	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T1INSYNC  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T1SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T1CONbits_t;
extern volatile __T1CONbits_t __at (0xFCD) T1CONbits;

extern __sfr __at (0xFCE) TMR1L;

extern __sfr __at (0xFCF) TMR1H;

extern __sfr __at (0xFD0) RCON;
typedef union {
	struct {
		unsigned NOT_BOR   	: 1;
		unsigned NOT_POR   	: 1;
		unsigned NOT_PD    	: 1;
		unsigned NOT_TO    	: 1;
		unsigned NOT_RI    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_IPEN  	: 1;
	};
	struct {
		unsigned BOR       	: 1;
		unsigned POR       	: 1;
		unsigned PD        	: 1;
		unsigned TO        	: 1;
		unsigned RI        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IPEN      	: 1;
	};
} __RCONbits_t;
extern volatile __RCONbits_t __at (0xFD0) RCONbits;

extern __sfr __at (0xFD1) WDTCON;
typedef union {
	struct {
		unsigned SWDTEN    	: 1;
		unsigned WDT0      	: 1;
		unsigned WDT1      	: 1;
		unsigned WDT2      	: 1;
		unsigned WDT3      	: 1;
		unsigned WDT4      	: 1;
		unsigned WDT5      	: 1;
		unsigned WDT6      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned WDTW      	: 1;
	};
} __WDTCONbits_t;
extern volatile __WDTCONbits_t __at (0xFD1) WDTCONbits;

extern __sfr __at (0xFD2) LVDCON;
typedef union {
	struct {
		unsigned LVDL0     	: 1;
		unsigned LVDL1     	: 1;
		unsigned LVDL2     	: 1;
		unsigned LVDL3     	: 1;
		unsigned LVDEN     	: 1;
		unsigned IRVST     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IVRST     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LVDCONbits_t;
extern volatile __LVDCONbits_t __at (0xFD2) LVDCONbits;

extern __sfr __at (0xFD3) OSCCON;
typedef union {
	struct {
		unsigned SCS0      	: 1;
		unsigned SCS1      	: 1;
		unsigned FLTS      	: 1;
		unsigned OSTS      	: 1;
		unsigned IRCF0     	: 1;
		unsigned IRCF1     	: 1;
		unsigned IRCF2     	: 1;
		unsigned IDLEN     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IOFS      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __OSCCONbits_t;
extern volatile __OSCCONbits_t __at (0xFD3) OSCCONbits;

extern __sfr __at (0xFD5) T0CON;
typedef union {
	struct {
		unsigned T0PS0     	: 1;
		unsigned T0PS1     	: 1;
		unsigned T0PS2     	: 1;
		unsigned PSA       	: 1;
		unsigned T0SE      	: 1;
		unsigned T0CS      	: 1;
		unsigned T016BIT   	: 1;
		unsigned TMR0ON    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T0PS3     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T0CONbits_t;
extern volatile __T0CONbits_t __at (0xFD5) T0CONbits;

extern __sfr __at (0xFD6) TMR0L;

extern __sfr __at (0xFD7) TMR0H;

extern __sfr __at (0xFD8) STATUS;
typedef union {
	struct {
		unsigned C         	: 1;
		unsigned DC        	: 1;
		unsigned Z         	: 1;
		unsigned OV        	: 1;
		unsigned N         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __STATUSbits_t;
extern volatile __STATUSbits_t __at (0xFD8) STATUSbits;

extern __sfr __at (0xFD9) FSR2L;

extern __sfr __at (0xFDA) FSR2H;

extern __sfr __at (0xFDB) PLUSW2;

extern __sfr __at (0xFDC) PREINC2;

extern __sfr __at (0xFDD) POSTDEC2;

extern __sfr __at (0xFDE) POSTINC2;

extern __sfr __at (0xFDF) INDF2;

extern __sfr __at (0xFE0) BSR;

extern __sfr __at (0xFE1) FSR1L;

extern __sfr __at (0xFE2) FSR1H;

extern __sfr __at (0xFE3) PLUSW1;

extern __sfr __at (0xFE4) PREINC1;

extern __sfr __at (0xFE5) POSTDEC1;

extern __sfr __at (0xFE6) POSTINC1;

extern __sfr __at (0xFE7) INDF1;

extern __sfr __at (0xFE8) WREG;

extern __sfr __at (0xFE9) FSR0L;

extern __sfr __at (0xFEA) FSR0H;

extern __sfr __at (0xFEB) PLUSW0;

extern __sfr __at (0xFEC) PREINC0;

extern __sfr __at (0xFED) POSTDEC0;

extern __sfr __at (0xFEE) POSTINC0;

extern __sfr __at (0xFEF) INDF0;

extern __sfr __at (0xFF0) INTCON3;
typedef union {
	struct {
		unsigned INT1IF    	: 1;
		unsigned INT2IF    	: 1;
		unsigned           	: 1;
		unsigned INT1IE    	: 1;
		unsigned INT2IE    	: 1;
		unsigned           	: 1;
		unsigned INT1IP    	: 1;
		unsigned INT2IP    	: 1;
	};
	struct {
		unsigned INT1F     	: 1;
		unsigned INT2F     	: 1;
		unsigned           	: 1;
		unsigned INT1E     	: 1;
		unsigned INT2E     	: 1;
		unsigned           	: 1;
		unsigned INT1P     	: 1;
		unsigned INT2P     	: 1;
	};
} __INTCON3bits_t;
extern volatile __INTCON3bits_t __at (0xFF0) INTCON3bits;

extern __sfr __at (0xFF1) INTCON2;
typedef union {
	struct {
		unsigned RBIP      	: 1;
		unsigned           	: 1;
		unsigned TMR0IP    	: 1;
		unsigned           	: 1;
		unsigned INTEDG2   	: 1;
		unsigned INTEDG1   	: 1;
		unsigned INTEDG0   	: 1;
		unsigned NOT_RBPU  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T0IP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RBPU      	: 1;
	};
} __INTCON2bits_t;
extern volatile __INTCON2bits_t __at (0xFF1) INTCON2bits;

extern __sfr __at (0xFF2) INTCON;
typedef union {
	struct {
		unsigned RBIF      	: 1;
		unsigned INT0IF    	: 1;
		unsigned TMR0IF    	: 1;
		unsigned RBIE      	: 1;
		unsigned INT0IE    	: 1;
		unsigned TMR0IE    	: 1;
		unsigned PEIE      	: 1;
		unsigned GIE       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT0F     	: 1;
		unsigned T0IF      	: 1;
		unsigned           	: 1;
		unsigned INT0E     	: 1;
		unsigned T0IE      	: 1;
		unsigned GIEL      	: 1;
		unsigned GIEH      	: 1;
	};
} __INTCONbits_t;
extern volatile __INTCONbits_t __at (0xFF2) INTCONbits;

extern __sfr __at (0xFF3) PROD;

extern __sfr __at (0xFF3) PRODL;

extern __sfr __at (0xFF4) PRODH;

extern __sfr __at (0xFF5) TABLAT;

extern __sfr __at (0xFF6) TBLPTR;

extern __sfr __at (0xFF6) TBLPTRL;

extern __sfr __at (0xFF7) TBLPTRH;

extern __sfr __at (0xFF8) TBLPTRU;

extern __sfr __at (0xFF9) PC;

extern __sfr __at (0xFF9) PCL;

extern __sfr __at (0xFFA) PCLATH;

extern __sfr __at (0xFFB) PCLATU;

extern __sfr __at (0xFFC) STKPTR;
typedef union {
	struct {
		unsigned STKPTR0   	: 1;
		unsigned STKPTR1   	: 1;
		unsigned STKPTR2   	: 1;
		unsigned STKPTR3   	: 1;
		unsigned STKPTR4   	: 1;
		unsigned           	: 1;
		unsigned STKUNF    	: 1;
		unsigned STKOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned STKFUL    	: 1;
	};
} __STKPTRbits_t;
extern volatile __STKPTRbits_t __at (0xFFC) STKPTRbits;

extern __sfr __at (0xFFD) TOS;

extern __sfr __at (0xFFD) TOSL;

extern __sfr __at (0xFFE) TOSH;

extern __sfr __at (0xFFF) TOSU;


#endif

