/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchResults
implements ISearchHitCollector {
    private ArrayList scopes;
    private int maxHits;
    private String locale;
    protected SearchHit[] searchHits = new SearchHit[0];

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
    }

    public void addHits(List hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode((String)highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        Iterator iter = hits.iterator();
        int i = 0;
        while (i < this.maxHits && iter.hasNext()) {
            block11: {
                ITopic t;
                AdaptableHelpResource scope;
                IToc toc;
                String href;
                SearchHit rawHit;
                block10: {
                    block9: {
                        rawHit = (SearchHit)iter.next();
                        href = rawHit.getHref();
                        toc = null;
                        scope = null;
                        if (this.scopes != null) break block9;
                        toc = this.getTocForTopic(href, this.locale);
                        break block10;
                    }
                    scope = this.getScopeForTopic(href);
                    if (scope == null) break block11;
                    toc = scope instanceof AdaptableToc ? (IToc)scope.getAdapter(IToc.class) : (IToc)scope.getParent().getAdapter(IToc.class);
                }
                float score = rawHit.getScore();
                if (!scoreScaleSet) {
                    if (score > 0.0f) {
                        scoreScale = 0.99f / score;
                        score = 1.0f;
                    }
                    scoreScaleSet = true;
                } else {
                    score = score * scoreScale + 0.01f;
                }
                String label = rawHit.getLabel();
                if ("".equals(label) && toc != null && (t = scope != null ? scope.getTopic(href) : toc.getTopic(href)) != null) {
                    label = t.getLabel();
                }
                if (label == null || "".equals(label)) {
                    label = href;
                }
                href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
                searchHitList.add(new SearchHit(href, label, rawHit.getRawSummary(), score, toc, rawHit.getRawId(), rawHit.getParticipantId(), rawHit.getFilters()));
            }
            ++i;
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        int i = 0;
        while (i < this.scopes.size()) {
            AdaptableHelpResource scope = (AdaptableHelpResource)this.scopes.get(i);
            if (scope.getTopic(href) != null) {
                return scope;
            }
            ++i;
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    private ArrayList getScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        this.scopes = new ArrayList(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            AdaptableHelpResource[] elements = wSets[w].getElements();
            int i = 0;
            while (i < elements.length) {
                this.scopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return this.scopes;
    }
}

