/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;

public class OpenLogEntryAction
extends CVSAction {
    protected ILogEntry[] getSelectedLogEntries() {
        ArrayList<Object> entries = null;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            entries = new ArrayList<Object>();
            for (Object next : selection) {
                IAdaptable a;
                Object adapter;
                if (next instanceof ILogEntry) {
                    entries.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(ILogEntry.class)) instanceof ILogEntry)) continue;
                entries.add(adapter);
            }
        }
        if (entries != null && !entries.isEmpty()) {
            ILogEntry[] result = new ILogEntry[entries.size()];
            entries.toArray(result);
            return result;
        }
        return new ILogEntry[0];
    }

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                ILogEntry[] entries = OpenLogEntryAction.this.getSelectedLogEntries();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].isDeletion()) {
                        MessageDialog.openError((Shell)OpenLogEntryAction.this.getShell(), (String)CVSUIMessages.OpenLogEntryAction_deletedTitle, (String)CVSUIMessages.OpenLogEntryAction_deleted);
                    } else {
                        ICVSRemoteFile file = entries[i].getRemoteFile();
                        CVSUIPlugin.getPlugin().openEditor(file, monitor);
                    }
                    ++i;
                }
            }
        }, false, 2);
    }

    protected boolean isEnabled() throws TeamException {
        ILogEntry[] entries = this.getSelectedLogEntries();
        return entries.length != 0;
    }
}

