/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.ui.internal.menus.LeafLocationElement;
import org.eclipse.ui.internal.menus.LocationElement;

public final class SPart
implements LocationElement {
    public static final int TYPE_CLASS = 0;
    public static final int TYPE_ID = 1;
    private final LeafLocationElement location;
    private final String part;
    private final int type;

    public SPart(String part, int type, LeafLocationElement location) {
        if (part == null) {
            throw new NullPointerException("A part needs a class or id");
        }
        if (type < 0 || type > 1) {
            throw new IllegalArgumentException("The part must be either a class or an identifier");
        }
        if (location == null) {
            throw new NullPointerException("A part needs a location for the menu element to appear");
        }
        this.part = part;
        this.type = type;
        this.location = location;
    }

    public final LocationElement createChild(String id) {
        LeafLocationElement childPath = (LeafLocationElement)this.getLocation().createChild(id);
        return new SPart(this.getPart(), this.getType(), childPath);
    }

    public final LeafLocationElement getLocation() {
        return this.location;
    }

    public final String getPart() {
        return this.part;
    }

    public final int getType() {
        return this.type;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SPart(");
        switch (this.type) {
            case 0: {
                buffer.append("class");
                break;
            }
            case 1: {
                buffer.append("id");
                break;
            }
            default: {
                buffer.append("unknown");
            }
        }
        buffer.append(',');
        buffer.append(this.part);
        buffer.append(',');
        buffer.append(this.location);
        buffer.append(')');
        return buffer.toString();
    }
}

