/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.SLocation;

public final class SItem
extends MenuElement {
    public static final String PROPERTY_COMMAND = "COMMAND";
    public static final String PROPERTY_MENU_ID = "MENU_ID";
    private ParameterizedCommand command;
    private String menuId;

    SItem(String id) {
        super(id);
    }

    public final void define(Command command, SLocation location) {
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        this.define(parameterizedCommand, null, location);
    }

    public final void define(ParameterizedCommand command, SLocation location) {
        this.define(command, null, location);
    }

    public final void define(ParameterizedCommand command, String menuId, SLocation location) {
        SLocation[] locations = location == null ? (SLocation[])null : new SLocation[]{location};
        this.define(command, menuId, locations);
    }

    public final void define(ParameterizedCommand command, String menuId, SLocation[] locations) {
        if (command == null) {
            throw new NullPointerException("An item needs a command");
        }
        this.setCommand(command);
        this.setMenuId(menuId);
        this.setLocations(locations);
        this.setDefined(true);
    }

    public final ParameterizedCommand getCommand() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the command from an undefined item");
        }
        return this.command;
    }

    public final String getMenuId() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the menu from an undefined item");
        }
        return this.menuId;
    }

    protected final void setCommand(ParameterizedCommand command) {
        if (!Util.equals((Object)this.command, (Object)command)) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_COMMAND, (Object)this.command, (Object)command);
            }
            this.command = command;
            this.firePropertyChangeEvent(event);
        }
    }

    protected final void setMenuId(String menuId) {
        if (!Util.equals((Object)this.menuId, (Object)menuId)) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_MENU_ID, (Object)this.menuId, (Object)menuId);
            }
            this.menuId = menuId;
            this.firePropertyChangeEvent(event);
        }
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SItem(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.command);
            stringBuffer.append(',');
            stringBuffer.append(this.menuId);
            stringBuffer.append(',');
            stringBuffer.append(this.locations);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        this.setCommand(null);
        this.setMenuId(null);
        this.setLocations(null);
        this.setDefined(false);
    }
}

