/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.fix.ILinkedFixRewriteOperation;
import org.eclipse.jdt.internal.corext.fix.PositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEditGroup;

public class LinkedFix
extends AbstractFix {
    private final IFixRewriteOperation[] fFixRewrites;
    private final CompilationUnit fCompilationUnit;
    private final List fPositionGroups;
    private ITrackedNodePosition fEndPosition;

    protected LinkedFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewrites) {
        super(name, compilationUnit, null);
        this.fCompilationUnit = compilationUnit;
        this.fFixRewrites = fixRewrites;
        this.fPositionGroups = new ArrayList();
    }

    public ITrackedNodePosition getEndPosition() {
        return this.fEndPosition;
    }

    public PositionGroup[] getPositionGroups() {
        return this.fPositionGroups.toArray(new PositionGroup[this.fPositionGroups.size()]);
    }

    public TextChange createChange() throws CoreException {
        if (this.fFixRewrites == null || this.fFixRewrites.length == 0) {
            return null;
        }
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite((ICompilationUnit)this.fCompilationUnit.getJavaElement(), this.fCompilationUnit);
        ArrayList groups = new ArrayList();
        this.fEndPosition = null;
        this.fPositionGroups.clear();
        int i = 0;
        while (i < this.fFixRewrites.length) {
            IFixRewriteOperation operation = this.fFixRewrites[i];
            if (operation instanceof ILinkedFixRewriteOperation) {
                ILinkedFixRewriteOperation linkedOperation = (ILinkedFixRewriteOperation)operation;
                this.fEndPosition = linkedOperation.rewriteAST(cuRewrite, groups, this.fPositionGroups);
            } else {
                operation.rewriteAST(cuRewrite, groups);
            }
            ++i;
        }
        CompilationUnitChange result = cuRewrite.createChange();
        for (TextEditGroup group : groups) {
            result.addTextEditGroup(group);
        }
        return result;
    }

    public static abstract class AbstractLinkedFixRewriteOperation
    extends AbstractFix.AbstractFixRewriteOperation
    implements ILinkedFixRewriteOperation {
        private Hashtable fPositionGroups;

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            this.rewriteAST(cuRewrite, textEditGroups, new ArrayList());
        }

        protected PositionGroup getPositionGroup(String parameterName) {
            if (!this.fPositionGroups.containsKey(parameterName)) {
                this.fPositionGroups.put(parameterName, new PositionGroup(parameterName));
            }
            return (PositionGroup)this.fPositionGroups.get(parameterName);
        }

        protected void clearPositionGroups() {
            if (this.fPositionGroups == null) {
                this.fPositionGroups = new Hashtable();
            } else {
                this.fPositionGroups.clear();
            }
        }

        protected Collection getAllPositionGroups() {
            if (this.fPositionGroups == null) {
                return null;
            }
            return this.fPositionGroups.values();
        }
    }
}

