/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.texteditor.IUpdate;

public final class CompositeRevertAction
extends Action
implements IUpdate {
    private final IAction[] fActions;

    public CompositeRevertAction(IAction[] actions) {
        this.fActions = new IAction[actions.length];
        int i = 0;
        while (i < actions.length) {
            Assert.isNotNull((Object)actions[i]);
            ++i;
        }
        System.arraycopy(actions, 0, this.fActions, 0, actions.length);
        this.update();
    }

    public void update() {
        int i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i] instanceof IUpdate) {
                ((IUpdate)this.fActions[i]).update();
            }
            ++i;
        }
        IAction action = this.getEnabledAction();
        if (action == null) {
            return;
        }
        this.setText(action.getText());
        this.setToolTipText(action.getToolTipText());
    }

    public boolean isEnabled() {
        this.update();
        return this.getEnabledAction() != null;
    }

    public void run() {
        IAction action = this.getEnabledAction();
        if (action != null) {
            action.run();
        }
    }

    private IAction getEnabledAction() {
        int i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i].isEnabled()) {
                return this.fActions[i];
            }
            ++i;
        }
        return null;
    }
}

