/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import java.util.List;
import org.eclipse.jface.internal.text.revisions.ChangeRegion;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;

public final class DiffApplier {
    public void applyDiff(List regions, ILineDiffer lineDiffer, int numberOfLines) {
        this.clearDiffs(regions);
        int added = 0;
        int changed = 0;
        ILineDiffInfo info = null;
        int line = 0;
        while (line < numberOfLines) {
            info = lineDiffer.getLineInfo(line);
            if (info != null) {
                int changeType = info.getChangeType();
                switch (changeType) {
                    case 1: {
                        ++added;
                        break;
                    }
                    case 2: {
                        ++changed;
                        break;
                    }
                    case 0: {
                        if ((added -= info.getRemovedLinesAbove()) == 0 && changed == 0) break;
                        this.applyDiff(regions, new Hunk(line - changed - Math.max(0, added), added, changed));
                        added = 0;
                        changed = 0;
                        info = null;
                    }
                }
            }
            ++line;
        }
        if (info != null && ((added -= info.getRemovedLinesAbove()) != 0 || changed != 0)) {
            this.applyDiff(regions, new Hunk(numberOfLines - changed, added, changed));
            added = 0;
            changed = 0;
        }
    }

    private void clearDiffs(List regions) {
        for (ChangeRegion region : regions) {
            region.clearDiff();
        }
    }

    private void applyDiff(List regions, Hunk hunk) {
        for (ChangeRegion region : regions) {
            region.adjustTo(hunk);
        }
    }
}

