/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph.canvas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.owasp.jbrofuzz.version.ImageCreator;

public class StatusCodeChart {
    private static final int MAX_CHARS = 32;
    private final String[] xData;
    private final String[] yData;
    private DefaultPieDataset dataset;
    private static final String ERROR = "---";

    public StatusCodeChart() {
        this(0);
    }

    public StatusCodeChart(int size) {
        this.xData = new String[size];
        this.yData = new String[size];
        this.dataset = new DefaultPieDataset();
        this.dataset.setValue((Comparable)((Object)"501"), 25.0);
        this.dataset.setValue((Comparable)((Object)"302"), 25.0);
        this.dataset.setValue((Comparable)((Object)"404"), 25.0);
        this.dataset.setValue((Comparable)((Object)"200"), 25.0);
    }

    /*
     * Loose catch block
     */
    private String calculateValue(File inputFile) {
        if (inputFile.isDirectory()) {
            return ERROR;
        }
        String status = ERROR;
        BufferedReader inbuffReader = null;
        try {
            int got;
            inbuffReader = new BufferedReader(new FileReader(inputFile));
            StringBuffer one = new StringBuffer(32);
            int counter = 0;
            while ((got = inbuffReader.read()) > 0 && counter < 32) {
                one.append((char)got);
                ++counter;
            }
            inbuffReader.close();
            one.delete(0, one.indexOf("\n--\n") + 4);
            one.delete(one.indexOf("\n--"), one.length());
            status = one.toString();
        }
        catch (IOException e1) {
            IOUtils.closeQuietly(inbuffReader);
            return ERROR;
        }
        catch (StringIndexOutOfBoundsException e2) {
            IOUtils.closeQuietly(inbuffReader);
            return ERROR;
        }
        catch (NumberFormatException e3) {
            IOUtils.closeQuietly(inbuffReader);
            return ERROR;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inbuffReader);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(inbuffReader);
        return status;
    }

    public void createFinalPlotCanvas() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] stringArray = this.yData;
        int n = this.yData.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (map.containsKey(n3)) {
                map.put(n3, (Integer)map.get(n3) + 1);
            } else {
                map.put(n3, 1);
            }
            ++n2;
        }
        this.dataset = new DefaultPieDataset();
        for (Map.Entry entry : map.entrySet()) {
            this.dataset.setValue((Comparable)entry.getKey(), (double)((Integer)entry.getValue()).intValue() / (double)this.yData.length);
        }
    }

    public ChartPanel getPlotCanvas() {
        JFreeChart chart = ChartFactory.createPieChart((String)"JBroFuzz Status Code Pie Chart", (PieDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
        Plot plot = chart.getPlot();
        plot.setBackgroundImage(ImageCreator.IMG_OWASP_MED.getImage());
        plot.setBackgroundImageAlignment(9);
        return new ChartPanel(chart);
    }

    public void setValueAt(int index, File inputFile) {
        this.xData[index] = inputFile.getName();
        this.yData[index] = this.calculateValue(inputFile);
    }
}

