/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.owasp.jbrofuzz.fuzz.ui.FuzzerRow;

public class FuzzersTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8133287501650660903L;
    private static final String[] COLUMNNAMES = new String[]{"Fuzzer ID", "Start", "End"};
    private final ArrayList<FuzzerRow> dataVector = new ArrayList();

    public void addRow(String name, String type, String id, int point1, int point2) {
        this.dataVector.add(new FuzzerRow(id, point1, point2));
        this.dataVector.trimToSize();
        this.fireTableRowsInserted(this.dataVector.size(), this.dataVector.size());
    }

    @Override
    public int getColumnCount() {
        return COLUMNNAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNNAMES[column];
    }

    public String getRow(int row) {
        return String.valueOf(row) + " - " + this.getValueAt(row, 0);
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        FuzzerRow record = this.dataVector.get(row);
        switch (column) {
            case 0: {
                return record.getId();
            }
            case 1: {
                return record.getStartPoint();
            }
            case 2: {
                return record.getEndPoint();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void removeRow(int row) {
        if (row > -1 && row < this.dataVector.size()) {
            this.dataVector.remove(row);
            this.fireTableRowsDeleted(0, row);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        FuzzerRow record = this.dataVector.get(row);
        if (column == 0) {
            record.setId((String)value);
        }
        if (column == 1) {
            record.setStartPoint((Integer)value);
        }
        if (column == 2) {
            record.setEndPoint((Integer)value);
        }
        this.fireTableCellUpdated(row, column);
    }
}

