/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.util.Iterator;
import org.owasp.jbrofuzz.core.Fuzzer;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;
import org.owasp.jbrofuzz.core.Prototype;

public class DoubleFuzzer
implements Iterator<String[]> {
    private final Fuzzer fuzzer1;
    private final Fuzzer fuzzer2;
    private final boolean isFuzzer1Bigger;

    protected DoubleFuzzer(Prototype proto1, int len1, Prototype proto2, int len2) throws NoSuchFuzzerException {
        this.fuzzer1 = new Fuzzer(proto1, len1);
        this.fuzzer2 = new Fuzzer(proto2, len2);
        this.isFuzzer1Bigger = this.fuzzer1.getMaximumValue() > this.fuzzer2.getMaximumValue();
    }

    public long getCurrentValue() {
        long cur2;
        long cur1 = this.fuzzer1.getCurrentValue();
        if (cur1 > (cur2 = this.fuzzer2.getCurrentValue())) {
            return cur1;
        }
        return cur2;
    }

    public String getId() {
        return "DoubleFuzzer( " + this.fuzzer1.getId() + ", " + this.fuzzer2.getId() + " )";
    }

    public long getMaximumValue() {
        if (this.isFuzzer1Bigger) {
            return this.fuzzer1.getMaximumValue();
        }
        return this.fuzzer2.getMaximumValue();
    }

    public String getName() {
        return "DoubleFuzzer( " + this.fuzzer1.getName() + ", " + this.fuzzer2.getName() + " )";
    }

    @Override
    public boolean hasNext() {
        if (this.isFuzzer1Bigger) {
            return this.fuzzer1.hasNext();
        }
        return this.fuzzer2.hasNext();
    }

    @Override
    public String[] next() {
        if (this.isFuzzer1Bigger) {
            if (!this.fuzzer2.hasNext()) {
                this.fuzzer2.resetCurrentValue();
            }
        } else if (!this.fuzzer1.hasNext()) {
            this.fuzzer1.resetCurrentValue();
        }
        String payload1 = this.fuzzer1.next();
        String payload2 = this.fuzzer2.next();
        return new String[]{payload1, payload2};
    }

    @Override
    public void remove() {
        this.fuzzer1.remove();
        this.fuzzer2.remove();
    }

    public int getPower() {
        return 2;
    }
}

