/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang.ArrayUtils;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.renderer.UserListCellRenderer;

public class ContextPanelUsersSelectComboBox
extends JComboBox<User> {
    private static final long serialVersionUID = 7254245073685076020L;
    private static ExtensionUserManagement usersExtension;

    private static void loadUsersManagementExtension() {
        if (usersExtension == null && (usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class)) == null) {
            throw new IllegalStateException("Trying to create MultiUserSelectBox without the ExtensionUsersManagement being enabled.");
        }
    }

    public ContextPanelUsersSelectComboBox(int n) {
        ContextPanelUsersSelectComboBox.loadUsersManagementExtension();
        UsersTableModel usersTableModel = usersExtension.getUIConfiguredUsersModel(n);
        this.setModel(new UsersListModel(usersTableModel));
        this.setRenderer(new UserListCellRenderer());
    }

    public User getSelectedUser() {
        return (User)this.getSelectedItem();
    }

    public void setCustomUsers(User[] userArray) {
        ((UsersListModel)this.getModel()).setCustomUsers(userArray);
    }

    public void setSelectedInternalItem(User user) {
        ((UsersListModel)this.getModel()).setSelectedInternalItem(user);
    }

    private static class UsersListModel
    extends AbstractListModel<User>
    implements ComboBoxModel<User>,
    TableModelListener {
        private static final long serialVersionUID = 5648260449088479312L;
        User selectedItem;
        UsersTableModel tableModel;
        User[] customUsers;

        public UsersListModel(UsersTableModel usersTableModel) {
            this.tableModel = usersTableModel;
            this.tableModel.addTableModelListener(this);
        }

        @Override
        public User getElementAt(int n) {
            if (n < this.tableModel.getRowCount()) {
                return (User)this.tableModel.getElement(n);
            }
            if (this.customUsers != null) {
                return this.customUsers[n - this.tableModel.getRowCount()];
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.tableModel.getUsers().size() + (this.customUsers == null ? 0 : this.customUsers.length);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (this.selectedItem != null && this.getSize() == 0) {
                this.setSelectedItem(null);
            } else if (this.selectedItem == null || (tableModelEvent.getType() == -1 || tableModelEvent.getType() == 0) && this.getIndexOf(this.selectedItem) == -1) {
                if (this.getSize() > 0) {
                    this.setSelectedItem(this.getElementAt(0));
                } else {
                    this.setSelectedItem(null);
                }
            }
            this.fireContentsChanged(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedItem == null && object == null) {
                return;
            }
            if (!(object instanceof User)) {
                return;
            }
            if (this.selectedItem != null && this.selectedItem.equals(object)) {
                return;
            }
            if (object != null && this.getIndexOf(object) == -1) {
                return;
            }
            this.selectedItem = (User)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public void setSelectedInternalItem(User user) {
            int n = this.getIndexOf(user);
            if (n != -1) {
                this.setSelectedItem(this.tableModel.getUsers().get(n));
            } else if (this.getSize() > 0) {
                this.setSelectedItem(this.getElementAt(0));
            } else {
                this.setSelectedItem(null);
            }
        }

        public int getIndexOf(Object object) {
            int n = this.tableModel.getUsers().indexOf(object);
            if (n < 0 && this.customUsers != null) {
                return ArrayUtils.indexOf((Object[])this.customUsers, (Object)object);
            }
            return n;
        }

        public void setCustomUsers(User[] userArray) {
            this.customUsers = userArray;
        }
    }
}

