/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

public final class URLResolver {
    private URLResolver() {
    }

    public static String resolveUrl(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Base URL must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Relative URL must not be null");
        }
        Url url = URLResolver.resolveUrl(URLResolver.parseUrl(string.trim()), string2.trim());
        return url.toString();
    }

    private static int indexOf(String string, char c, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static Url parseUrl(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        String string2;
        int n5;
        Url url = new Url();
        int n6 = 0;
        int n7 = string.length();
        int n8 = URLResolver.indexOf(string, '#', n6, n7);
        if (n8 >= 0) {
            url.fragment_ = string.substring(n8 + 1, n7);
            n7 = n8;
        }
        if ((n5 = URLResolver.indexOf(string, ':', n6, n7)) > 0 && URLResolver.isValidScheme(string2 = string.substring(n6, n5))) {
            url.scheme_ = string2;
            n6 = n5 + 1;
        }
        if (string.startsWith("//", n6)) {
            n4 = n6 + 2;
            n3 = URLResolver.indexOf(string, '/', n4, n7);
            if (n3 >= 0) {
                n6 = n3;
            }
        } else {
            n4 = -1;
            n3 = -1;
        }
        if ((n2 = URLResolver.indexOf(string, '?', n6, n7)) >= 0) {
            if (n4 >= 0 && n3 < 0) {
                n3 = n2;
                n6 = n2;
            }
            url.query_ = string.substring(n2 + 1, n7);
            n7 = n2;
        }
        if ((n = URLResolver.indexOf(string, ';', n6, n7)) >= 0) {
            if (n4 >= 0 && n3 < 0) {
                n3 = n;
                n6 = n;
            }
            url.parameters_ = string.substring(n + 1, n7);
            n7 = n;
        }
        if (n4 >= 0 && n3 < 0) {
            n3 = n7;
        } else if (n6 < n7) {
            url.path_ = string.substring(n6, n7);
        }
        if (n4 >= 0 && n3 >= 0) {
            url.location_ = string.substring(n4, n3);
        }
        return url;
    }

    private static boolean isValidScheme(String string) {
        int n = string.length();
        if (n <= 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static Url resolveUrl(Url url, String string) {
        int n;
        String string2;
        int n2;
        Url url2 = URLResolver.parseUrl(string);
        if (url == null) {
            return url2;
        }
        if (string.length() == 0) {
            return new Url(url);
        }
        if (url2.scheme_ != null) {
            return url2;
        }
        url2.scheme_ = url.scheme_;
        if (url2.location_ != null) {
            return url2;
        }
        url2.location_ = url.location_;
        if (url2.path_ != null && url2.path_.length() > 0 && '/' == url2.path_.charAt(0)) {
            url2.path_ = URLResolver.removeLeadingSlashPoints(url2.path_);
            return url2;
        }
        if (url2.path_ == null) {
            url2.path_ = url.path_;
            if (url2.parameters_ != null) {
                return url2;
            }
            url2.parameters_ = url.parameters_;
            if (url2.query_ != null) {
                return url2;
            }
            url2.query_ = url.query_;
            return url2;
        }
        String string3 = url.path_;
        String string4 = "";
        if (string3 != null) {
            n2 = string3.lastIndexOf(47);
            if (n2 >= 0) {
                string4 = string3.substring(0, n2 + 1);
            }
        } else {
            string4 = "/";
        }
        string4 = string4.concat(url2.path_);
        while ((n2 = string4.indexOf("/./")) >= 0) {
            string4 = string4.substring(0, n2 + 1).concat(string4.substring(n2 + 3));
        }
        if (string4.endsWith("/.")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        while ((n2 = string4.indexOf("/../")) > 0) {
            string2 = string4.substring(0, n2);
            n = string2.lastIndexOf(47);
            if (n < 0 || "..".equals(string2.substring(n))) continue;
            string4 = string4.substring(0, n + 1).concat(string4.substring(n2 + 4));
        }
        if (string4.endsWith("/..") && (n = (string2 = string4.substring(0, string4.length() - 3)).lastIndexOf(47)) >= 0) {
            string4 = string4.substring(0, n + 1);
        }
        string4 = URLResolver.removeLeadingSlashPoints(string4);
        url2.path_ = string4;
        return url2;
    }

    private static String removeLeadingSlashPoints(String string) {
        while (string.startsWith("/..")) {
            string = string.substring(3);
        }
        return string;
    }

    private static class Url {
        private String scheme_;
        private String location_;
        private String path_;
        private String parameters_;
        private String query_;
        private String fragment_;

        public Url() {
        }

        public Url(Url url) {
            this.scheme_ = url.scheme_;
            this.location_ = url.location_;
            this.path_ = url.path_;
            this.parameters_ = url.parameters_;
            this.query_ = url.query_;
            this.fragment_ = url.fragment_;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.scheme_ != null) {
                stringBuilder.append(this.scheme_);
                stringBuilder.append(':');
            }
            if (this.location_ != null) {
                stringBuilder.append("//");
                stringBuilder.append(this.location_);
            }
            if (this.path_ != null) {
                stringBuilder.append(this.path_);
            }
            if (this.parameters_ != null) {
                stringBuilder.append(';');
                stringBuilder.append(this.parameters_);
            }
            if (this.query_ != null) {
                stringBuilder.append('?');
                stringBuilder.append(this.query_);
            }
            if (this.fragment_ != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.fragment_);
            }
            return stringBuilder.toString();
        }
    }
}

