/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpBody;

public class HttpResponseBody
extends HttpBody {
    private static final Logger log = Logger.getLogger(HttpResponseBody.class);
    private static final Pattern patternCharset = Pattern.compile("<META +[^>]+charset *= *['\\x22]?([^>'\\x22;]+)['\\x22]? *[/]?>", 2);

    public HttpResponseBody() {
    }

    public HttpResponseBody(int n) {
        super(n);
    }

    public HttpResponseBody(String string) {
        super(string);
    }

    @Override
    public String createCachedString(String string) {
        String string2 = null;
        if (this.isChangedCharset) {
            try {
                string2 = new String(this.getBytes(), string);
                this.isChangedCharset = false;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error((Object)("Unable to encode with the \"Content-Type\" charset: " + unsupportedEncodingException.getMessage()));
            }
        }
        if (string2 == null) {
            string2 = this.createCachedStringWithMetaCharset();
        }
        return string2;
    }

    private String createCachedStringWithMetaCharset() {
        String string = null;
        String string2 = null;
        try {
            string2 = new String(this.getBytes(), "8859_1");
            Matcher matcher = patternCharset.matcher(string2);
            if (matcher.find()) {
                String string3 = matcher.group(1);
                string = new String(this.getBytes(), string3);
                this.setCharset(string3);
                this.isChangedCharset = false;
            } else {
                String string4 = this.toUTF8();
                if (string4 != null) {
                    this.setCharset("UTF8");
                    this.isChangedCharset = false;
                    string = string4;
                } else {
                    string = string2;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)("Unable to encode with the (X)HTML meta charset: " + unsupportedEncodingException.getMessage()));
            log.warn((Object)"Using default charset: 8859_1");
            string = string2;
        }
        return string;
    }

    private String toUTF8() {
        String string = null;
        byte[] byArray = this.getBytes();
        int n = 0;
        try {
            string = new String(byArray, "UTF8");
            n = string.getBytes("UTF8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"UTF8 not supported. Using 8859_1 instead.");
            return null;
        }
        if (byArray.length != n) {
            return null;
        }
        return string;
    }
}

