/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.ParameterParser;

public class StandardParameterParser
implements ParameterParser {
    private static final String CONFIG_KV_PAIR_SEPARATORS = "kvps";
    private static final String CONFIG_KV_SEPARATORS = "kvs";
    private static final String CONFIG_STRUCTURAL_PARAMS = "struct";
    private Pattern keyValuePairSeparatorPattern;
    private Pattern keyValueSeparatorPattern;
    private String keyValuePairSeparators;
    private String keyValueSeparators;
    private List<String> structuralParameters = new ArrayList<String>();
    private static Logger log = Logger.getLogger(StandardParameterParser.class);

    public StandardParameterParser(String string, String string2) throws PatternSyntaxException {
        this.setKeyValuePairSeparators(string);
        this.setKeyValueSeparators(string2);
    }

    public StandardParameterParser() {
        this("&", "=");
    }

    private Pattern getKeyValuePairSeparatorPattern() {
        return this.keyValuePairSeparatorPattern;
    }

    private Pattern getKeyValueSeparatorPattern() {
        return this.keyValueSeparatorPattern;
    }

    @Override
    public void init(String string) {
        try {
            JSONObject jSONObject = JSONObject.fromObject((Object)string);
            this.setKeyValuePairSeparators(jSONObject.getString(CONFIG_KV_PAIR_SEPARATORS));
            this.setKeyValueSeparators(jSONObject.getString(CONFIG_KV_SEPARATORS));
            JSONArray jSONArray = jSONObject.getJSONArray(CONFIG_STRUCTURAL_PARAMS);
            for (Object object : jSONArray.toArray()) {
                this.structuralParameters.add(object.toString());
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public String getConfig() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)CONFIG_KV_PAIR_SEPARATORS, (Object)this.getKeyValuePairSeparators());
        jSONObject.put((Object)CONFIG_KV_SEPARATORS, (Object)this.getKeyValueSeparators());
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll(this.structuralParameters);
        jSONObject.put((Object)CONFIG_STRUCTURAL_PARAMS, (Object)jSONArray);
        return jSONObject.toString();
    }

    @Override
    public Map<String, String> getParams(HttpMessage httpMessage, HtmlParameter.Type type) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (httpMessage == null) {
            return hashMap;
        }
        try {
            switch (type) {
                case form: {
                    return this.parse(httpMessage.getRequestBody().toString());
                }
                case url: {
                    return this.parse(httpMessage.getRequestHeader().getURI().getQuery());
                }
            }
            throw new InvalidParameterException("Type not supported: " + (Object)((Object)type));
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
            return hashMap;
        }
    }

    private void setKeyValueSeparatorPattern(Pattern pattern) {
        this.keyValueSeparatorPattern = pattern;
    }

    private void setKeyValuePairSeparatorPattern(Pattern pattern) {
        this.keyValuePairSeparatorPattern = pattern;
    }

    public String getKeyValuePairSeparators() {
        return this.keyValuePairSeparators;
    }

    public void setKeyValuePairSeparators(String string) throws PatternSyntaxException {
        this.setKeyValuePairSeparatorPattern(Pattern.compile("[" + string + "]"));
        this.keyValuePairSeparators = string;
    }

    public String getKeyValueSeparators() {
        return this.keyValueSeparators;
    }

    public void setKeyValueSeparators(String string) throws PatternSyntaxException {
        this.setKeyValueSeparatorPattern(Pattern.compile("[" + string + "]"));
        this.keyValueSeparators = string;
    }

    @Override
    public String getDefaultKeyValuePairSeparator() {
        if (this.keyValuePairSeparators != null && this.keyValuePairSeparators.length() > 0) {
            return this.keyValuePairSeparators.substring(0, 1);
        }
        return "&";
    }

    @Override
    public String getDefaultKeyValueSeparator() {
        if (this.keyValueSeparators != null && this.keyValueSeparators.length() > 0) {
            return this.keyValueSeparators.substring(0, 1);
        }
        return "=";
    }

    public List<String> getStructuralParameters() {
        return Collections.unmodifiableList(this.structuralParameters);
    }

    public void setStructuralParameters(List<String> list) {
        this.structuralParameters.clear();
        this.structuralParameters.addAll(list);
    }

    @Override
    public Map<String, String> parse(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            String[] stringArray = this.getKeyValuePairSeparatorPattern().split(string);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String[] stringArray2 = this.getKeyValueSeparatorPattern().split(stringArray[i]);
                    if (stringArray2.length == 1) {
                        hashMap.put(stringArray2[0], "");
                        continue;
                    }
                    if (stringArray2.length <= 1) continue;
                    hashMap.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return hashMap;
    }

    @Override
    public StandardParameterParser clone() {
        StandardParameterParser standardParameterParser = new StandardParameterParser(this.getKeyValuePairSeparators(), this.getKeyValueSeparators());
        standardParameterParser.setStructuralParameters(this.getStructuralParameters());
        return standardParameterParser;
    }

    @Override
    public List<String> getTreePath(URI uRI) throws URIException {
        Object object;
        String string = uRI.getPath();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            object = string.split("/");
            for (int i = 1; i < ((String[])object).length; ++i) {
                arrayList.add((String)object[i]);
            }
        }
        object = this.parse(uRI.getQuery());
        ArrayList arrayList2 = new ArrayList(object.keySet());
        Collections.sort(arrayList2);
        for (String string2 : arrayList2) {
            if (!this.structuralParameters.contains(string2)) continue;
            arrayList.add((String)object.get(string2));
        }
        return arrayList;
    }

    @Override
    public List<String> getTreePath(HttpMessage httpMessage) throws URIException {
        URI uRI = httpMessage.getRequestHeader().getURI();
        List<String> list = this.getTreePath(uRI);
        Map<String, String> map = this.parse(httpMessage.getRequestBody().toString());
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            if (!this.structuralParameters.contains(string)) continue;
            list.add(map.get(string));
        }
        return list;
    }

    @Override
    public String getAncestorPath(URI uRI, int n) throws URIException {
        int n2;
        String string = uRI.getPath();
        if (n == 0 || string == null) {
            return "";
        }
        String[] stringArray = string.split("/");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (n2 = 1; n2 < stringArray.length && n > 0; ++n2, --n) {
            stringBuilder.append('/').append(stringArray[n2]);
        }
        if (n == 0 || this.structuralParameters.isEmpty()) {
            return stringBuilder.toString();
        }
        n2 = 1;
        Map<String, String> map = this.parse(uRI.getQuery());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!this.structuralParameters.contains(entry.getKey())) continue;
            if (n2 != 0) {
                n2 = 0;
                stringBuilder.append('?');
            } else {
                stringBuilder.append(this.keyValuePairSeparators);
            }
            stringBuilder.append(entry.getKey()).append(this.keyValueSeparators).append(entry.getValue());
            if (--n != 0) continue;
            break;
        }
        return stringBuilder.toString();
    }
}

