/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderPanelTableModel;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.ScanListenner2;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.view.ScanPanel2;
import org.zaproxy.zap.view.ZapTable;

public class SpiderPanel
extends ScanPanel2<SpiderScan, ScanController<SpiderScan>>
implements ScanListenner2 {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SpiderPanel.class);
    private static final SpiderPanelTableModel EMPTY_RESULTS_MODEL = new SpiderPanelTableModel();
    public static final String PANEL_NAME = "SpiderPanel";
    private JButton scanButton = null;
    private ZapTable resultsTable;
    private JScrollPane workPane;
    private JLabel foundCountNameLabel;
    private JLabel foundCountValueLabel;
    private ExtensionSpider extension = null;

    public SpiderPanel(ExtensionSpider extensionSpider, SpiderParam spiderParam) {
        super("spider", new ImageIcon(SpiderPanel.class.getResource("/resource/icon/16/spider.png")), extensionSpider, spiderParam);
        this.extension = extensionSpider;
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("spider.panel.mnemonic"));
    }

    @Override
    protected JScrollPane getWorkPanel() {
        if (this.workPane == null) {
            this.workPane = new JScrollPane();
            this.workPane.setName("SpiderResultsPane");
            this.workPane.setViewportView((Component)this.getScanResultsTable());
        }
        return this.workPane;
    }

    private void setScanResultsTableColumnSizes() {
        this.resultsTable.getColumnModel().getColumn(0).setMinWidth(80);
        this.resultsTable.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.resultsTable.getColumnModel().getColumn(1).setMinWidth(60);
        this.resultsTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.resultsTable.getColumnModel().getColumn(2).setMinWidth(300);
        this.resultsTable.getColumnModel().getColumn(3).setMinWidth(50);
        this.resultsTable.getColumnModel().getColumn(3).setPreferredWidth(250);
    }

    private JXTable getScanResultsTable() {
        if (this.resultsTable == null) {
            this.resultsTable = new ZapTable(EMPTY_RESULTS_MODEL);
            this.resultsTable.setColumnSelectionAllowed(false);
            this.resultsTable.setCellSelectionEnabled(false);
            this.resultsTable.setRowSelectionAllowed(true);
            this.resultsTable.setAutoCreateRowSorter(true);
            this.setScanResultsTableColumnSizes();
            this.resultsTable.setName(PANEL_NAME);
            this.resultsTable.setDoubleBuffered(true);
            this.resultsTable.setSelectionMode(0);
            this.resultsTable.setComponentPopupMenu(new JPopupMenu(){
                private static final long serialVersionUID = 6608291059686282641L;

                @Override
                public void show(Component component, int n, int n2) {
                    View.getSingleton().getPopupMenu().show(component, n, n2);
                }
            });
        }
        return this.resultsTable;
    }

    private JLabel getFoundCountNameLabel() {
        if (this.foundCountNameLabel == null) {
            this.foundCountNameLabel = new JLabel();
            this.foundCountNameLabel.setText(Constant.messages.getString("spider.toolbar.found.label"));
        }
        return this.foundCountNameLabel;
    }

    private JLabel getFoundCountValueLabel() {
        if (this.foundCountValueLabel == null) {
            this.foundCountValueLabel = new JLabel();
            this.foundCountValueLabel.setText("0");
        }
        return this.foundCountValueLabel;
    }

    @Override
    protected int addToolBarElements(JToolBar jToolBar, ScanPanel2.Location location, int n) {
        if (ScanPanel2.Location.afterProgressBar == location) {
            jToolBar.add((Component)this.getFoundCountNameLabel(), this.getGBC(n++, 0, 0.0, new Insets(0, 5, 0, 0)));
            jToolBar.add((Component)this.getFoundCountValueLabel(), this.getGBC(n++, 0));
        }
        return n;
    }

    protected void updateFoundCount() {
        SpiderScan spiderScan = (SpiderScan)this.getSelectedScanner();
        if (spiderScan != null) {
            this.getFoundCountValueLabel().setText(Integer.toString(spiderScan.getResourcesFound().size()));
        } else {
            this.getFoundCountValueLabel().setText("");
        }
    }

    @Override
    protected void switchView(final SpiderScan spiderScan) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SpiderPanel.this.switchView(spiderScan);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                log.error((Object)("Failed to switch view: " + exception.getMessage()), (Throwable)exception);
            }
            return;
        }
        if (spiderScan != null) {
            this.getScanResultsTable().setModel(spiderScan.getResultsTableModel());
            this.setScanResultsTableColumnSizes();
        } else {
            this.getScanResultsTable().setModel((TableModel)EMPTY_RESULTS_MODEL);
        }
        this.updateFoundCount();
    }

    @Override
    public JButton getNewScanButton() {
        if (this.scanButton == null) {
            this.scanButton = new JButton(Constant.messages.getString("spider.toolbar.button.new"));
            this.scanButton.setIcon(new ImageIcon(SpiderPanel.class.getResource("/resource/icon/16/spider.png")));
            this.scanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SpiderPanel.this.extension.showSpiderDialog(null);
                }
            });
        }
        return this.scanButton;
    }

    @Override
    protected int getNumberOfScansToShow() {
        return this.extension.getSpiderParam().getMaxScansInUI();
    }
}

