/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.all.response;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseAllPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    private static final String CSS = Constant.messages.getString("http.panel.view.syntaxtext.syntax.css");
    private static final String HTML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.html");
    private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
    private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
    private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");

    public HttpResponseAllPanelSyntaxHighlightTextView(ResponseStringHttpPanelViewModel responseStringHttpPanelViewModel) {
        super(responseStringHttpPanelViewModel);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseAllPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseAllPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = 3665478428546560762L;
        private static final Logger log = Logger.getLogger(HttpResponseAllPanelSyntaxHighlightTextArea.class);
        private static ResponseAllTokenMakerFactory tokenMakerFactory = null;

        public HttpResponseAllPanelSyntaxHighlightTextArea() {
            this.addSyntaxStyle(CSS, "text/css");
            this.addSyntaxStyle(HTML, "text/html");
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
        }

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            HttpMessage httpMessage = (HttpMessage)this.getMessage();
            int n = 0;
            String string = httpMessage.getResponseHeader().toString();
            int n2 = 0;
            while ((n2 = string.indexOf("\r\n", n2)) != -1) {
                n2 += 2;
                ++n;
            }
            int n3 = string.length();
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                int n4 = matcher.start();
                int n5 = matcher.end();
                if (n4 + n < n3) {
                    try {
                        n4 += this.getLineOfOffset(n4);
                    }
                    catch (BadLocationException badLocationException) {
                        log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                        return;
                    }
                    try {
                        n5 += this.getLineOfOffset(n5);
                    }
                    catch (BadLocationException badLocationException) {
                        log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                        return;
                    }
                    if (n5 > n3) {
                        n5 = n3;
                    }
                    list.add(new SearchMatch(SearchMatch.Location.RESPONSE_HEAD, n4, n5));
                    continue;
                }
                list.add(new SearchMatch(SearchMatch.Location.RESPONSE_BODY, n4 += n - n3, n5 += n - n3));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            int n;
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)searchMatch.getLocation()) && !SearchMatch.Location.RESPONSE_BODY.equals((Object)searchMatch.getLocation())) {
                return;
            }
            boolean bl = SearchMatch.Location.RESPONSE_BODY.equals((Object)searchMatch.getLocation());
            int n2 = 0;
            String string = searchMatch.getMessage().getResponseHeader().toString();
            int n3 = 0;
            while ((n3 = string.indexOf("\r\n", n3)) != -1 && (bl || (n3 += 2) <= searchMatch.getStart())) {
                ++n2;
            }
            int n4 = searchMatch.getStart() - n2;
            int n5 = searchMatch.getEnd() - n2;
            if (bl) {
                n4 += string.length();
                n5 += string.length();
            }
            if (n4 > (n = this.getText().length()) || n5 > n) {
                return;
            }
            this.highlight(n4, n5);
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String string;
            String string2 = null;
            if (httpMessage != null && httpMessage.getResponseHeader() != null && (string = httpMessage.getResponseHeader().getHeader("Content-Type")) != null && !string.isEmpty()) {
                int n = (string = string.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (n != -1) {
                    string = string.substring(0, n).trim();
                }
                string2 = string.contains("javascript") ? "text/javascript" : (string.contains("json") ? "text/json" : (string.contains("xhtml") ? "text/html" : (string.contains("xml") ? "text/xml" : string)));
            }
            return string2;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseAllTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseAllTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public ResponseAllTokenMakerFactory() {
                String string = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/css", string + "CSSTokenMaker");
                this.putMapping("text/html", string + "HTMLTokenMaker");
                this.putMapping("text/javascript", string + "JavaScriptTokenMaker");
                this.putMapping("text/json", string + "JsonTokenMaker");
                this.putMapping("text/xml", string + "XMLTokenMaker");
            }
        }
    }
}

