/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.configuration.FileConfiguration;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.AbstractStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelEvent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelListener;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelView;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSingleHttpMessageContainer;

public abstract class HttpPanelSyntaxHighlightTextView
implements HttpPanelView,
HttpPanelViewModelListener,
SearchableHttpPanelView {
    public static final String DEFAULT_MESSAGE_CONTAINER_NAME = "HttpMessagePanel";
    public static final String NAME = "HttpPanelSyntaxHighlightTextView";
    private static final String CAPTION_NAME = Constant.messages.getString("http.panel.view.text.name");
    private HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
    private JPanel mainPanel;
    private AbstractStringHttpPanelViewModel model;
    private String configurationKey;
    private final String messageContainerName;

    public HttpPanelSyntaxHighlightTextView(AbstractStringHttpPanelViewModel abstractStringHttpPanelViewModel) {
        this(DEFAULT_MESSAGE_CONTAINER_NAME, abstractStringHttpPanelViewModel);
    }

    public HttpPanelSyntaxHighlightTextView(String string, AbstractStringHttpPanelViewModel abstractStringHttpPanelViewModel) {
        this.model = abstractStringHttpPanelViewModel;
        this.messageContainerName = string;
        this.configurationKey = "";
        this.init();
        this.model.addHttpPanelViewModelListener(this);
    }

    private void init() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.httpPanelTextArea = this.createHttpPanelTextArea();
        this.httpPanelTextArea.setEditable(false);
        this.httpPanelTextArea.setComponentPopupMenu(new CustomPopupMenu());
        RTextScrollPane rTextScrollPane = new RTextScrollPane((Component)((Object)this.httpPanelTextArea), false);
        rTextScrollPane.setVerticalScrollBarPolicy(20);
        this.mainPanel.add((Component)rTextScrollPane, "Center");
    }

    protected abstract HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea();

    protected HttpPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return this.httpPanelTextArea;
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.httpPanelTextArea.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getCaptionName() {
        return CAPTION_NAME;
    }

    @Override
    public String getTargetViewName() {
        return "HttpPanelTextView";
    }

    @Override
    public int getPosition() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isEnabled(Message message) {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    @Override
    public JComponent getPane() {
        return this.mainPanel;
    }

    @Override
    public boolean isEditable() {
        return this.httpPanelTextArea.isEditable();
    }

    @Override
    public void setEditable(boolean bl) {
        this.httpPanelTextArea.setEditable(bl);
    }

    @Override
    public HttpPanelViewModel getModel() {
        return this.model;
    }

    @Override
    public void dataChanged(HttpPanelViewModelEvent httpPanelViewModelEvent) {
        this.httpPanelTextArea.setMessage(this.model.getMessage());
        boolean bl = this.httpPanelTextArea.isEditable();
        boolean bl2 = this.model.getData().isEmpty();
        if (bl2 || !bl) {
            this.httpPanelTextArea.discardAllEdits();
        }
        this.httpPanelTextArea.setText(this.model.getData());
        this.httpPanelTextArea.setCaretPosition(0);
        if (bl2 || !bl) {
            this.httpPanelTextArea.discardAllEdits();
        }
    }

    @Override
    public void save() {
        this.model.setData(this.httpPanelTextArea.getText());
    }

    @Override
    public void search(Pattern pattern, List<SearchMatch> list) {
        this.httpPanelTextArea.search(pattern, list);
    }

    @Override
    public void highlight(SearchMatch searchMatch) {
        this.httpPanelTextArea.highlight(searchMatch);
    }

    @Override
    public void setParentConfigurationKey(String string) {
        this.configurationKey = string + NAME + ".";
    }

    @Override
    public void loadConfiguration(FileConfiguration fileConfiguration) {
        this.httpPanelTextArea.loadConfiguration(this.configurationKey, fileConfiguration);
    }

    @Override
    public void saveConfiguration(FileConfiguration fileConfiguration) {
        this.httpPanelTextArea.saveConfiguration(this.configurationKey, fileConfiguration);
    }

    protected class CustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected CustomPopupMenu() {
        }

        @Override
        public void show(Component component, int n, int n2) {
            if (!HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.isFocusOwner()) {
                HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.requestFocusInWindow();
            }
            if (HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.getMessage() instanceof HttpMessage) {
                DefaultSingleHttpMessageContainer defaultSingleHttpMessageContainer = new DefaultSingleHttpMessageContainer(HttpPanelSyntaxHighlightTextView.this.messageContainerName, (Component)((Object)HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea), (HttpMessage)HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.getMessage());
                View.getSingleton().getPopupMenu().show(defaultSingleHttpMessageContainer, n, n2);
            } else {
                View.getSingleton().getPopupMenu().show((Component)((Object)HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea), n, n2);
            }
        }
    }
}

