/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.largeresponse;

import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.component.split.request.RequestSplitComponent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.largeresponse.LargeResponseStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.largeresponse.LargeResponseUtil;
import org.zaproxy.zap.extension.httppanel.view.largeresponse.ResponseLargeResponseAllView;
import org.zaproxy.zap.extension.httppanel.view.largeresponse.ResponseLargeResponseSplitView;
import org.zaproxy.zap.view.HttpPanelManager;

public class ExtensionHttpPanelLargeResponseView
extends ExtensionAdaptor {
    public static final String NAME = "ExtensionHttpPanelLargeResponseView";

    public ExtensionHttpPanelLargeResponseView() {
        super(NAME);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            HttpPanelManager httpPanelManager = HttpPanelManager.getInstance();
            httpPanelManager.addResponseViewFactory("ResponseSplit", new ResponseLargeResponseSplitViewFactory());
            httpPanelManager.addResponseDefaultViewSelectorFactory("ResponseSplit", new LargeResponseDefaultSplitViewSelectorFactory());
            httpPanelManager.addResponseViewFactory("ResponseAll", new ResponseLargeResponseAllViewFactory());
            httpPanelManager.addResponseDefaultViewSelectorFactory("ResponseAll", new LargeResponseDefaultAllViewSelectorFactory());
        }
    }

    @Override
    public boolean canUnload() {
        return false;
    }

    @Override
    public void unload() {
        if (this.getView() != null) {
            HttpPanelManager httpPanelManager = HttpPanelManager.getInstance();
            httpPanelManager.removeResponseViewFactory("ResponseSplit", "ResponseLargeResponseSplitViewFactory");
            httpPanelManager.removeResponseViews("ResponseSplit", "ResponseLargeResponseSplitView", (Object)RequestSplitComponent.ViewComponent.BODY);
            httpPanelManager.removeResponseDefaultViewSelectorFactory("ResponseSplit", "LargeResponseDefaultSplitViewSelectorFactory");
            httpPanelManager.removeResponseDefaultViewSelectors("ResponseSplit", "LargeResponseDefaultSplitViewSelector", (Object)RequestSplitComponent.ViewComponent.BODY);
            httpPanelManager.removeResponseViewFactory("ResponseAll", "ResponseLargeResponseAllViewFactory");
            httpPanelManager.removeResponseViews("ResponseAll", "ResponseLargeResponseAllView", null);
            httpPanelManager.removeResponseDefaultViewSelectorFactory("ResponseAll", "LargeResponseDefaultAllViewSelectorFactory");
            httpPanelManager.removeResponseDefaultViewSelectors("ResponseAll", "LargeResponseDefaultAllViewSelector", null);
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    private static final class LargeResponseDefaultAllViewSelectorFactory
    implements HttpPanelManager.HttpPanelDefaultViewSelectorFactory {
        private static HttpPanelDefaultViewSelector defaultViewSelector = null;
        public static final String NAME = "LargeResponseDefaultAllViewSelectorFactory";

        private LargeResponseDefaultAllViewSelectorFactory() {
        }

        private HttpPanelDefaultViewSelector getDefaultViewSelector() {
            if (defaultViewSelector == null) {
                this.createViewSelector();
            }
            return defaultViewSelector;
        }

        private synchronized void createViewSelector() {
            if (defaultViewSelector == null) {
                defaultViewSelector = new LargeResponseDefaultAllViewSelector();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelDefaultViewSelector getNewDefaultViewSelector() {
            return this.getDefaultViewSelector();
        }

        @Override
        public Object getOptions() {
            return null;
        }
    }

    private static final class LargeResponseDefaultSplitViewSelectorFactory
    implements HttpPanelManager.HttpPanelDefaultViewSelectorFactory {
        private static HttpPanelDefaultViewSelector defaultViewSelector = null;
        public static final String NAME = "LargeResponseDefaultSplitViewSelectorFactory";

        private LargeResponseDefaultSplitViewSelectorFactory() {
        }

        private HttpPanelDefaultViewSelector getDefaultViewSelector() {
            if (defaultViewSelector == null) {
                this.createViewSelector();
            }
            return defaultViewSelector;
        }

        private synchronized void createViewSelector() {
            if (defaultViewSelector == null) {
                defaultViewSelector = new LargeResponseDefaultSplitViewSelector();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelDefaultViewSelector getNewDefaultViewSelector() {
            return this.getDefaultViewSelector();
        }

        @Override
        public Object getOptions() {
            return RequestSplitComponent.ViewComponent.BODY;
        }
    }

    private static final class LargeResponseDefaultAllViewSelector
    implements HttpPanelDefaultViewSelector {
        public static final String NAME = "LargeResponseDefaultAllViewSelector";

        private LargeResponseDefaultAllViewSelector() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean matchToDefaultView(Message message) {
            return LargeResponseUtil.isLargeResponse(message);
        }

        @Override
        public String getViewName() {
            return "ResponseLargeResponseAllView";
        }

        @Override
        public int getOrder() {
            return 50;
        }
    }

    private static final class ResponseLargeResponseAllViewFactory
    implements HttpPanelManager.HttpPanelViewFactory {
        public static final String NAME = "ResponseLargeResponseAllViewFactory";

        private ResponseLargeResponseAllViewFactory() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelView getNewView() {
            return new ResponseLargeResponseAllView(new LargeResponseStringHttpPanelViewModel());
        }

        @Override
        public Object getOptions() {
            return null;
        }
    }

    private static final class LargeResponseDefaultSplitViewSelector
    implements HttpPanelDefaultViewSelector {
        public static final String NAME = "LargeResponseDefaultSplitViewSelector";

        private LargeResponseDefaultSplitViewSelector() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean matchToDefaultView(Message message) {
            return LargeResponseUtil.isLargeResponse(message);
        }

        @Override
        public String getViewName() {
            return "ResponseLargeResponseSplitView";
        }

        @Override
        public int getOrder() {
            return 50;
        }
    }

    private static final class ResponseLargeResponseSplitViewFactory
    implements HttpPanelManager.HttpPanelViewFactory {
        public static final String NAME = "ResponseLargeResponseSplitViewFactory";

        private ResponseLargeResponseSplitViewFactory() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelView getNewView() {
            return new ResponseLargeResponseSplitView();
        }

        @Override
        public Object getOptions() {
            return RequestSplitComponent.ViewComponent.BODY;
        }
    }
}

