/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.view.LayoutHelper;

public class BreakpointsOptionsPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 7483614036849207715L;
    private JCheckBox checkBoxConfirmDropMessage = null;
    private JCheckBox checkBoxAlwaysOnTop = null;
    private JComboBox<String> buttonMode = null;

    public BreakpointsOptionsPanel() {
        this.setName(Constant.messages.getString("brk.optionspanel.name"));
        this.setLayout(new CardLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        jPanel.add((Component)this.getCheckBoxConfirmDropMessage(), LayoutHelper.getGBC(0, 0, 2, 1.0, new Insets(2, 2, 2, 2)));
        jPanel.add((Component)this.getCheckBoxAlwaysOnTop(), LayoutHelper.getGBC(0, 1, 2, 1.0, new Insets(2, 2, 2, 2)));
        JLabel jLabel = new JLabel(Constant.messages.getString("brk.optionspanel.option.breakmode.label"));
        jLabel.setLabelFor(this.getButtonMode());
        jPanel.add((Component)jLabel, LayoutHelper.getGBC(0, 2, 1, 0.5));
        jPanel.add(this.getButtonMode(), LayoutHelper.getGBC(1, 2, 1, 0.5));
        jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 1, 0.5, 1.0));
        this.add(jPanel);
    }

    private JCheckBox getCheckBoxConfirmDropMessage() {
        if (this.checkBoxConfirmDropMessage == null) {
            this.checkBoxConfirmDropMessage = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.confirmDropMessage.label"));
        }
        return this.checkBoxConfirmDropMessage;
    }

    private JCheckBox getCheckBoxAlwaysOnTop() {
        if (this.checkBoxAlwaysOnTop == null) {
            this.checkBoxAlwaysOnTop = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.alwaysOnTop.label"));
        }
        return this.checkBoxAlwaysOnTop;
    }

    private JComboBox<String> getButtonMode() {
        if (this.buttonMode == null) {
            this.buttonMode = new JComboBox();
            this.buttonMode.addItem(Constant.messages.getString("brk.optionspanel.option.breakmode.simple.label"));
            this.buttonMode.addItem(Constant.messages.getString("brk.optionspanel.option.breakmode.dual.label"));
        }
        return this.buttonMode;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        BreakpointsParam breakpointsParam = optionsParam.getParamSet(BreakpointsParam.class);
        this.getCheckBoxConfirmDropMessage().setSelected(breakpointsParam.isConfirmDropMessage());
        this.getCheckBoxAlwaysOnTop().setSelected(breakpointsParam.getAlwaysOnTop() != Boolean.FALSE);
        this.getButtonMode().setSelectedIndex(breakpointsParam.getButtonMode() - 1);
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        BreakpointsParam breakpointsParam = optionsParam.getParamSet(BreakpointsParam.class);
        breakpointsParam.setConfirmDropMessage(this.getCheckBoxConfirmDropMessage().isSelected());
        if (breakpointsParam.getAlwaysOnTop() != null || !this.getCheckBoxAlwaysOnTop().isSelected()) {
            breakpointsParam.setAlwaysOnTop(this.getCheckBoxAlwaysOnTop().isSelected());
        }
        breakpointsParam.setButtonMode(this.getButtonMode().getSelectedIndex() + 1);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.breakpoints";
    }
}

