/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import edu.umass.cs.benchlab.har.HarEntries;
import edu.umass.cs.benchlab.har.HarLog;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.tree.TreeNode;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.extension.report.ReportLastScan;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseConversionUtils;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.dynssl.ExtensionDynSSL;
import org.zaproxy.zap.model.SessionUtils;
import org.zaproxy.zap.utils.HarUtils;
import org.zaproxy.zap.utils.Stats;

public class CoreAPI
extends ApiImplementor
implements SessionListener {
    private static final Logger logger = Logger.getLogger(CoreAPI.class);
    private static final String PREFIX = "core";
    private static final String ACTION_LOAD_SESSION = "loadSession";
    private static final String ACTION_NEW_SESSION = "newSession";
    private static final String ACTION_SAVE_SESSION = "saveSession";
    private static final String ACTION_SNAPSHOT_SESSION = "snapshotSession";
    private static final String ACTION_SHUTDOWN = "shutdown";
    private static final String ACTION_EXCLUDE_FROM_PROXY = "excludeFromProxy";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_PROXY = "clearExcludedFromProxy";
    private static final String ACTION_SET_HOME_DIRECTORY = "setHomeDirectory";
    private static final String ACTION_GENERATE_ROOT_CA = "generateRootCA";
    private static final String ACTION_SEND_REQUEST = "sendRequest";
    private static final String ACTION_DELETE_ALL_ALERTS = "deleteAllAlerts";
    private static final String ACTION_COLLECT_GARBAGE = "runGarbageCollection";
    private static final String ACTION_CLEAR_STATS = "clearStats";
    private static final String VIEW_ALERT = "alert";
    private static final String VIEW_ALERTS = "alerts";
    private static final String VIEW_NUMBER_OF_ALERTS = "numberOfAlerts";
    private static final String VIEW_HOSTS = "hosts";
    private static final String VIEW_SITES = "sites";
    private static final String VIEW_URLS = "urls";
    private static final String VIEW_MESSAGE = "message";
    private static final String VIEW_MESSAGES = "messages";
    private static final String VIEW_NUMBER_OF_MESSAGES = "numberOfMessages";
    private static final String VIEW_VERSION = "version";
    private static final String VIEW_EXCLUDED_FROM_PROXY = "excludedFromProxy";
    private static final String VIEW_HOME_DIRECTORY = "homeDirectory";
    private static final String VIEW_STATS = "stats";
    private static final String OTHER_PROXY_PAC = "proxy.pac";
    private static final String OTHER_SET_PROXY = "setproxy";
    private static final String OTHER_ROOT_CERT = "rootcert";
    private static final String OTHER_XML_REPORT = "xmlreport";
    private static final String OTHER_HTML_REPORT = "htmlreport";
    private static final String OTHER_MESSAGE_HAR = "messageHar";
    private static final String OTHER_MESSAGES_HAR = "messagesHar";
    private static final String OTHER_SEND_HAR_REQUEST = "sendHarRequest";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_DIR = "dir";
    private static final String PARAM_SESSION = "name";
    private static final String PARAM_OVERWRITE_SESSION = "overwrite";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_START = "start";
    private static final String PARAM_PROXY_DETAILS = "proxy";
    private static final String PARAM_ID = "id";
    private static final String PARAM_REQUEST = "request";
    private static final String PARAM_FOLLOW_REDIRECTS = "followRedirects";
    private static final String PARAM_KEY_PREFIX = "keyPrefix";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private boolean savingSession = false;

    public CoreAPI() {
        this.addApiAction(new ApiAction(ACTION_SHUTDOWN));
        this.addApiAction(new ApiAction(ACTION_NEW_SESSION, null, new String[]{PARAM_SESSION, PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_LOAD_SESSION, new String[]{PARAM_SESSION}));
        this.addApiAction(new ApiAction(ACTION_SAVE_SESSION, new String[]{PARAM_SESSION}, new String[]{PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_SNAPSHOT_SESSION));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_PROXY));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_PROXY, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_SET_HOME_DIRECTORY, new String[]{PARAM_DIR}));
        this.addApiAction(new ApiAction(ACTION_GENERATE_ROOT_CA));
        this.addApiAction(new ApiAction(ACTION_SEND_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiAction(new ApiAction(ACTION_DELETE_ALL_ALERTS));
        this.addApiAction(new ApiAction(ACTION_COLLECT_GARBAGE));
        this.addApiAction(new ApiAction(ACTION_CLEAR_STATS, new String[]{PARAM_KEY_PREFIX}));
        this.addApiView(new ApiView(VIEW_ALERT, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_ALERTS, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView(VIEW_HOSTS));
        this.addApiView(new ApiView(VIEW_SITES));
        this.addApiView(new ApiView(VIEW_URLS));
        this.addApiView(new ApiView(VIEW_MESSAGE, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_MESSAGES, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_MESSAGES, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView(VIEW_VERSION));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_PROXY));
        this.addApiView(new ApiView(VIEW_HOME_DIRECTORY));
        this.addApiView(new ApiView(VIEW_STATS, null, new String[]{PARAM_KEY_PREFIX}));
        this.addApiOthers(new ApiOther(OTHER_PROXY_PAC, false));
        this.addApiOthers(new ApiOther(OTHER_ROOT_CERT, false));
        this.addApiOthers(new ApiOther(OTHER_SET_PROXY, new String[]{PARAM_PROXY_DETAILS}));
        this.addApiOthers(new ApiOther(OTHER_XML_REPORT));
        this.addApiOthers(new ApiOther(OTHER_HTML_REPORT));
        this.addApiOthers(new ApiOther(OTHER_MESSAGE_HAR, new String[]{PARAM_ID}));
        this.addApiOthers(new ApiOther(OTHER_MESSAGES_HAR, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiOthers(new ApiOther(OTHER_SEND_HAR_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiShortcut(OTHER_PROXY_PAC);
        this.addApiShortcut(OTHER_SET_PROXY);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        Session session = Model.getSingleton().getSession();
        if (ACTION_SHUTDOWN.equals(string)) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Control.getSingleton().shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
                    logger.info((Object)(Constant.PROGRAM_TITLE + " terminated."));
                    System.exit(0);
                }
            };
            thread.start();
            return ApiResponseElement.OK;
        }
        if (ACTION_SAVE_SESSION.equalsIgnoreCase(string)) {
            Path path = SessionUtils.getSessionPath(jSONObject.getString(PARAM_SESSION));
            String string2 = path.toAbsolutePath().toString();
            boolean bl = this.getParam(jSONObject, PARAM_OVERWRITE_SESSION, false);
            boolean bl2 = false;
            if (!session.isNewState()) {
                try {
                    bl2 = Files.isSameFile(Paths.get(session.getFileName(), new String[0]), path);
                }
                catch (IOException iOException) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, iOException.getMessage());
                }
            }
            if (Files.exists(path, new LinkOption[0]) && (!bl || bl2)) {
                throw new ApiException(ApiException.Type.ALREADY_EXISTS, string2);
            }
            this.savingSession = true;
            try {
                Control.getSingleton().saveSession(string2, this);
            }
            catch (Exception exception) {
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)interruptedException.getMessage(), (Throwable)interruptedException);
            }
            logger.debug((Object)"Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_SNAPSHOT_SESSION.equalsIgnoreCase(string)) {
            if (session.isNewState()) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            String string3 = session.getFileName();
            if (string3.endsWith(".session")) {
                string3 = string3.substring(0, string3.length() - 8);
            }
            string3 = string3 + "-" + this.dateFormat.format(new Date()) + ".session";
            this.savingSession = true;
            try {
                Control.getSingleton().snapshotSession(string3, this);
            }
            catch (Exception exception) {
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)interruptedException.getMessage(), (Throwable)interruptedException);
            }
            logger.debug((Object)"Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_LOAD_SESSION.equalsIgnoreCase(string)) {
            Path path = SessionUtils.getSessionPath(jSONObject.getString(PARAM_SESSION));
            String string4 = path.toAbsolutePath().toString();
            if (!Files.exists(path, new LinkOption[0])) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, string4);
            }
            try {
                Control.getSingleton().runCommandLineOpenSession(string4);
                return ApiResponseElement.OK;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            }
        }
        if (ACTION_NEW_SESSION.equalsIgnoreCase(string)) {
            String string5 = null;
            try {
                string5 = jSONObject.getString(PARAM_SESSION);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string5 == null || string5.length() == 0) {
                Control.getSingleton().discardSession();
                try {
                    Control.getSingleton().createAndOpenUntitledDb();
                }
                catch (Exception exception) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                }
                Control.getSingleton().newSession();
                return ApiResponseElement.OK;
            }
            Path path = SessionUtils.getSessionPath(string5);
            String string6 = path.toAbsolutePath().toString();
            boolean bl = this.getParam(jSONObject, PARAM_OVERWRITE_SESSION, false);
            if (Files.exists(path, new LinkOption[0]) && !bl) {
                throw new ApiException(ApiException.Type.ALREADY_EXISTS, string6);
            }
            try {
                Control.getSingleton().runCommandLineNewSession(string6);
                return ApiResponseElement.OK;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            }
        }
        if (ACTION_CLEAR_EXCLUDED_FROM_PROXY.equals(string)) {
            try {
                session.setExcludeFromProxyRegexs(new ArrayList<String>());
                return ApiResponseElement.OK;
            }
            catch (DatabaseException databaseException) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
            }
        }
        if (ACTION_EXCLUDE_FROM_PROXY.equals(string)) {
            String string7 = jSONObject.getString(PARAM_REGEX);
            try {
                session.addExcludeFromProxyRegex(string7);
                return ApiResponseElement.OK;
            }
            catch (DatabaseException databaseException) {
                logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
            }
        }
        if (ACTION_SET_HOME_DIRECTORY.equals(string)) {
            File file = new File(jSONObject.getString(PARAM_DIR));
            if (!file.exists() || !file.isDirectory()) throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_DIR);
            Model.getSingleton().getOptionsParam().setUserDirectory(file);
            return ApiResponseElement.OK;
        }
        if (ACTION_GENERATE_ROOT_CA.equals(string)) {
            ExtensionDynSSL extensionDynSSL = (ExtensionDynSSL)Control.getSingleton().getExtensionLoader().getExtension("ExtensionDynSSL");
            if (extensionDynSSL == null) return ApiResponseElement.OK;
            try {
                extensionDynSSL.createNewRootCa();
                return ApiResponseElement.OK;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            }
        }
        if (ACTION_SEND_REQUEST.equals(string)) {
            HttpMessage httpMessage;
            try {
                httpMessage = CoreAPI.createRequest(jSONObject.getString(PARAM_REQUEST));
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, httpMalformedHeaderException);
            }
            boolean bl = this.getParam(jSONObject, PARAM_FOLLOW_REDIRECTS, false);
            final ApiResponseList apiResponseList = new ApiResponseList(string);
            try {
                CoreAPI.sendRequest(httpMessage, bl, new Processor<HttpMessage>(){

                    @Override
                    public void process(HttpMessage httpMessage) {
                        int n = httpMessage.getHistoryRef() != null ? httpMessage.getHistoryRef().getHistoryId() : -1;
                        apiResponseList.addItem(ApiResponseConversionUtils.httpMessageToSet(n, httpMessage));
                    }
                });
                return apiResponseList;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            }
        }
        if (ACTION_DELETE_ALL_ALERTS.equals(string)) {
            ExtensionAlert extensionAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
            if (extensionAlert != null) {
                extensionAlert.deleteAllAlerts();
                return ApiResponseElement.OK;
            }
            try {
                Model.getSingleton().getDb().getTableAlert().deleteAllAlerts();
            }
            catch (DatabaseException databaseException) {
                logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
            }
            SiteNode siteNode = (SiteNode)Model.getSingleton().getSession().getSiteTree().getRoot();
            siteNode.deleteAllAlerts();
            CoreAPI.removeHistoryReferenceAlerts(siteNode);
            return ApiResponseElement.OK;
        }
        if (ACTION_COLLECT_GARBAGE.equals(string)) {
            System.gc();
            return ApiResponseElement.OK;
        }
        if (!ACTION_CLEAR_STATS.equals(string)) throw new ApiException(ApiException.Type.BAD_ACTION);
        Stats.clear(this.getParam(jSONObject, PARAM_KEY_PREFIX, ""));
        return ApiResponseElement.OK;
    }

    private static HttpMessage createRequest(String string) throws HttpMalformedHeaderException {
        HttpMessage httpMessage = new HttpMessage();
        String[] stringArray = string.split(Pattern.quote("\r\n\r\n"), 2);
        httpMessage.setRequestHeader(stringArray[0]);
        if (stringArray.length > 1) {
            httpMessage.setRequestBody(stringArray[1]);
        } else {
            httpMessage.setRequestBody("");
        }
        return httpMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRequest(HttpMessage httpMessage, boolean bl, Processor<HttpMessage> processor) throws IOException {
        HttpSender httpSender = null;
        try {
            httpSender = CoreAPI.createHttpSender();
            httpSender.sendAndReceive(httpMessage);
            CoreAPI.persistMessage(httpMessage);
            processor.process(httpMessage);
            if (bl) {
                HttpMessage httpMessage2 = httpMessage;
                for (int i = 0; i < 10 && HttpStatusCode.isRedirection(httpMessage2.getResponseHeader().getStatusCode()); ++i) {
                    httpMessage2 = httpMessage2.cloneAll();
                    String string = httpMessage2.getResponseHeader().getHeader("Location");
                    URI uRI = httpMessage2.getRequestHeader().getURI();
                    URI uRI2 = new URI(uRI, string, false);
                    httpMessage2.getRequestHeader().setURI(uRI2);
                    httpMessage2.getRequestHeader().setMethod("GET");
                    httpMessage2.getRequestHeader().setHeader("Content-Length", null);
                    httpSender.sendAndReceive(httpMessage2);
                    CoreAPI.persistMessage(httpMessage2);
                    processor.process(httpMessage);
                }
            }
        }
        finally {
            if (httpSender != null) {
                httpSender.shutdown();
            }
        }
    }

    private static HttpSender createHttpSender() {
        return new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 6);
    }

    private static void persistMessage(final HttpMessage httpMessage) {
        HistoryReference historyReference;
        try {
            historyReference = new HistoryReference(Model.getSingleton().getSession(), 15, httpMessage);
        }
        catch (Exception exception) {
            logger.warn((Object)exception.getMessage(), (Throwable)exception);
            return;
        }
        final ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        if (extensionHistory != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    extensionHistory.addHistory(historyReference);
                    Model.getSingleton().getSession().getSiteTree().addPath(historyReference, httpMessage);
                }
            });
        }
    }

    private static void removeHistoryReferenceAlerts(SiteNode siteNode) {
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            CoreAPI.removeHistoryReferenceAlerts((SiteNode)siteNode.getChildAt(i));
        }
        if (siteNode.getHistoryReference() != null) {
            siteNode.getHistoryReference().deleteAllAlerts();
        }
        for (HistoryReference historyReference : siteNode.getPastHistoryReference()) {
            historyReference.deleteAllAlerts();
        }
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse = null;
        Session session = Model.getSingleton().getSession();
        if (VIEW_HOSTS.equals(string)) {
            apiResponse = new ApiResponseList(string);
            SiteNode siteNode = (SiteNode)session.getSiteTree().getRoot();
            Enumeration<TreeNode> enumeration = siteNode.children();
            while (enumeration.hasMoreElements()) {
                String string2 = ((SiteNode)enumeration.nextElement()).getNodeName();
                if (string2.indexOf("//") >= 0) {
                    string2 = string2.substring(string2.indexOf("//") + 2);
                }
                if (string2.indexOf(":") >= 0) {
                    string2 = string2.substring(0, string2.indexOf(":"));
                }
                apiResponse.addItem(new ApiResponseElement("host", string2));
            }
        } else if (VIEW_SITES.equals(string)) {
            apiResponse = new ApiResponseList(string);
            SiteNode siteNode = (SiteNode)session.getSiteTree().getRoot();
            Enumeration<TreeNode> enumeration = siteNode.children();
            while (enumeration.hasMoreElements()) {
                apiResponse.addItem(new ApiResponseElement("site", ((SiteNode)enumeration.nextElement()).getNodeName()));
            }
        } else if (VIEW_URLS.equals(string)) {
            apiResponse = new ApiResponseList(string);
            SiteNode siteNode = (SiteNode)session.getSiteTree().getRoot();
            this.getURLs(siteNode, (ApiResponseList)apiResponse);
        } else if (VIEW_ALERT.equals(string)) {
            RecordAlert recordAlert;
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            try {
                recordAlert = tableAlert.read(this.getParam(jSONObject, PARAM_ID, -1));
            }
            catch (DatabaseException databaseException) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
            if (recordAlert == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            apiResponse = new ApiResponseElement(this.alertToSet(new Alert(recordAlert)));
        } else if (VIEW_ALERTS.equals(string)) {
            final ApiResponseList apiResponseList = new ApiResponseList(string);
            this.processAlerts(this.getParam(jSONObject, PARAM_BASE_URL, null), this.getParam(jSONObject, PARAM_START, -1), this.getParam(jSONObject, PARAM_COUNT, -1), new Processor<Alert>(){

                @Override
                public void process(Alert alert) {
                    apiResponseList.addItem(CoreAPI.this.alertToSet(alert));
                }
            });
            apiResponse = apiResponseList;
        } else if (VIEW_NUMBER_OF_ALERTS.equals(string)) {
            CounterProcessor<Alert> counterProcessor = new CounterProcessor<Alert>();
            this.processAlerts(this.getParam(jSONObject, PARAM_BASE_URL, null), this.getParam(jSONObject, PARAM_START, -1), this.getParam(jSONObject, PARAM_COUNT, -1), counterProcessor);
            apiResponse = new ApiResponseElement(string, Integer.toString(counterProcessor.getCount()));
        } else if (VIEW_MESSAGE.equals(string)) {
            RecordHistory recordHistory;
            TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
            try {
                recordHistory = tableHistory.read(this.getParam(jSONObject, PARAM_ID, -1));
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
            if (recordHistory == null || recordHistory.getHistoryType() == 0) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            apiResponse = new ApiResponseElement(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHttpMessage()));
        } else if (VIEW_MESSAGES.equals(string)) {
            final ApiResponseList apiResponseList = new ApiResponseList(string);
            this.processHttpMessages(this.getParam(jSONObject, PARAM_BASE_URL, null), this.getParam(jSONObject, PARAM_START, -1), this.getParam(jSONObject, PARAM_COUNT, -1), new Processor<RecordHistory>(){

                @Override
                public void process(RecordHistory recordHistory) {
                    apiResponseList.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHttpMessage()));
                }
            });
            apiResponse = apiResponseList;
        } else if (VIEW_NUMBER_OF_MESSAGES.equals(string)) {
            CounterProcessor<RecordHistory> counterProcessor = new CounterProcessor<RecordHistory>();
            this.processHttpMessages(this.getParam(jSONObject, PARAM_BASE_URL, null), this.getParam(jSONObject, PARAM_START, -1), this.getParam(jSONObject, PARAM_COUNT, -1), counterProcessor);
            apiResponse = new ApiResponseElement(string, Integer.toString(counterProcessor.getCount()));
        } else if (VIEW_VERSION.equals(string)) {
            apiResponse = new ApiResponseElement(string, Constant.PROGRAM_VERSION);
        } else if (VIEW_EXCLUDED_FROM_PROXY.equals(string)) {
            apiResponse = new ApiResponseList(string);
            List<String> list = session.getExcludeFromProxyRegexs();
            for (String string3 : list) {
                apiResponse.addItem(new ApiResponseElement(PARAM_REGEX, string3));
            }
        } else if (VIEW_HOME_DIRECTORY.equals(string)) {
            apiResponse = new ApiResponseElement(string, Model.getSingleton().getOptionsParam().getUserDirectory().getAbsolutePath());
        } else if (VIEW_STATS.equals(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, Long> entry : Stats.getStats(this.getParam(jSONObject, PARAM_KEY_PREFIX, "")).entrySet()) {
                hashMap.put(entry.getKey(), Long.toString(entry.getValue()));
            }
            apiResponse = new ApiResponseSet(string, hashMap);
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return apiResponse;
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage httpMessage, String string, JSONObject jSONObject) throws ApiException {
        if (OTHER_PROXY_PAC.equals(string)) {
            ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
            int n = proxyParam.getProxyPort();
            try {
                String string2;
                String string3 = null;
                if (proxyParam.isProxyIpAnyLocalAddress() && !API.API_DOMAIN.equals(string2 = httpMessage.getRequestHeader().getHostName())) {
                    string3 = string2;
                }
                if (string3 == null) {
                    string3 = proxyParam.getProxyIp();
                }
                string2 = this.getPacFile(string3, n);
                httpMessage.setResponseHeader(API.getDefaultResponseHeader("text/html", string2.length()));
                httpMessage.setResponseBody(string2);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return httpMessage;
        }
        if (OTHER_SET_PROXY.equals(string)) {
            String string4 = jSONObject.getString(PARAM_PROXY_DETAILS);
            String string5 = "OK";
            try {
                try {
                    JSONObject jSONObject2 = JSONObject.fromObject((Object)string4);
                    if (jSONObject2.getInt("type") == 1) {
                        JSONObject jSONObject3 = JSONObject.fromObject((Object)jSONObject2.get("http"));
                        String string6 = jSONObject3.getString("host");
                        int n = jSONObject3.getInt("port");
                        if (string6 != null && string6.length() > 0 && n > 0) {
                            Model.getSingleton().getOptionsParam().getConnectionParam().setProxyChainName(string6);
                            Model.getSingleton().getOptionsParam().getConnectionParam().setProxyChainPort(n);
                        }
                    }
                }
                catch (JSONException jSONException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_PROXY_DETAILS);
                }
                httpMessage.setResponseHeader(API.getDefaultResponseHeader("text/html", string5.length()));
                httpMessage.setResponseBody(string5);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return httpMessage;
        }
        if (OTHER_ROOT_CERT.equals(string)) {
            ExtensionDynSSL extensionDynSSL = (ExtensionDynSSL)Control.getSingleton().getExtensionLoader().getExtension("ExtensionDynSSL");
            if (extensionDynSSL != null) {
                try {
                    Certificate certificate = extensionDynSSL.getRootCA();
                    if (certificate == null) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
                    }
                    StringWriter stringWriter = new StringWriter();
                    try (Object object = new PemWriter((Writer)stringWriter);){
                        object.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)certificate));
                        object.flush();
                    }
                    object = stringWriter.toString();
                    httpMessage.setResponseHeader(API.getDefaultResponseHeader("application/pkix-cert;", ((String)object).length()));
                    httpMessage.setResponseBody((String)object);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR);
                }
            }
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            return httpMessage;
        }
        if (OTHER_XML_REPORT.equals(string)) {
            try {
                CoreAPI.writeReportLastScanTo(httpMessage, ScanReportType.XML);
                return httpMessage;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_HTML_REPORT.equals(string)) {
            try {
                CoreAPI.writeReportLastScanTo(httpMessage, ScanReportType.HTML);
                return httpMessage;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_MESSAGE_HAR.equals(string)) {
            byte[] byArray;
            try {
                RecordHistory recordHistory;
                HarEntries harEntries = new HarEntries();
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                try {
                    recordHistory = tableHistory.read(this.getParam(jSONObject, PARAM_ID, -1));
                }
                catch (DatabaseException | HttpMalformedHeaderException exception) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR);
                }
                if (recordHistory == null || recordHistory.getHistoryType() == 0) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
                }
                harEntries.addEntry(HarUtils.createHarEntry(recordHistory.getHttpMessage()));
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(harEntries);
                byArray = HarUtils.harLogToByteArray(harLog);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                byArray = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            try {
                httpMessage.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", byArray.length));
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                logger.error((Object)("Failed to create response header: " + httpMalformedHeaderException.getMessage()), (Throwable)httpMalformedHeaderException);
            }
            httpMessage.setResponseBody(byArray);
            return httpMessage;
        }
        if (OTHER_MESSAGES_HAR.equals(string)) {
            byte[] byArray;
            try {
                final HarEntries harEntries = new HarEntries();
                this.processHttpMessages(this.getParam(jSONObject, PARAM_BASE_URL, null), this.getParam(jSONObject, PARAM_START, -1), this.getParam(jSONObject, PARAM_COUNT, -1), new Processor<RecordHistory>(){

                    @Override
                    public void process(RecordHistory recordHistory) {
                        harEntries.addEntry(HarUtils.createHarEntry(recordHistory.getHttpMessage()));
                    }
                });
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(harEntries);
                byArray = HarUtils.harLogToByteArray(harLog);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                byArray = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            try {
                httpMessage.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", byArray.length));
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                logger.error((Object)("Failed to create response header: " + httpMalformedHeaderException.getMessage()), (Throwable)httpMalformedHeaderException);
            }
            httpMessage.setResponseBody(byArray);
            return httpMessage;
        }
        if (OTHER_SEND_HAR_REQUEST.equals(string)) {
            ApiException apiException;
            byte[] byArray = new byte[]{};
            HttpMessage httpMessage2 = null;
            try {
                httpMessage2 = HarUtils.createHttpMessage(jSONObject.getString(PARAM_REQUEST));
            }
            catch (IOException iOException) {
                apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, iOException);
                byArray = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
                httpMessage.setResponseBody(byArray);
            }
            if (httpMessage2 != null) {
                boolean bl = this.getParam(jSONObject, PARAM_FOLLOW_REDIRECTS, false);
                try {
                    apiException = new HarEntries();
                    CoreAPI.sendRequest(httpMessage2, bl, new Processor<HttpMessage>((HarEntries)apiException){
                        final /* synthetic */ HarEntries val$entries;
                        {
                            this.val$entries = harEntries;
                        }

                        @Override
                        public void process(HttpMessage httpMessage) {
                            this.val$entries.addEntry(HarUtils.createHarEntry(httpMessage));
                        }
                    });
                    HarLog harLog = HarUtils.createZapHarLog();
                    harLog.setEntries((HarEntries)apiException);
                    byArray = HarUtils.harLogToByteArray(harLog);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                    ApiException apiException2 = new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                    byArray = apiException2.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
                }
            }
            try {
                httpMessage.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", byArray.length));
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                logger.error((Object)("Failed to create response header: " + httpMalformedHeaderException.getMessage()), (Throwable)httpMalformedHeaderException);
            }
            httpMessage.setResponseBody(byArray);
            return httpMessage;
        }
        throw new ApiException(ApiException.Type.BAD_OTHER);
    }

    private boolean incErrorDetails() {
        return Model.getSingleton().getOptionsParam().getApiParam().isIncErrorDetails();
    }

    private static void writeReportLastScanTo(HttpMessage httpMessage, ScanReportType scanReportType) throws Exception {
        ReportLastScan reportLastScan = new ReportLastScan();
        StringBuilder stringBuilder = new StringBuilder();
        reportLastScan.generate(stringBuilder, Model.getSingleton());
        String string = ScanReportType.XML == scanReportType ? "xml" : "html";
        String string2 = ReportGenerator.stringToHtml(stringBuilder.toString(), Paths.get(Constant.getZapInstall(), "xml/report." + string + ".xsl").toString());
        httpMessage.setResponseHeader(API.getDefaultResponseHeader("text/" + string + "; charset=UTF-8"));
        httpMessage.setResponseBody(string2);
        httpMessage.getResponseHeader().setContentLength(httpMessage.getResponseBody().length());
    }

    @Override
    public HttpMessage handleShortcut(HttpMessage httpMessage) throws ApiException {
        try {
            if (httpMessage.getRequestHeader().getURI().getPath().startsWith("/proxy.pac")) {
                return this.handleApiOther(httpMessage, OTHER_PROXY_PAC, null);
            }
            if (httpMessage.getRequestHeader().getURI().getPath().startsWith("/setproxy")) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)PARAM_PROXY_DETAILS, (Object)httpMessage.getRequestBody());
                return this.handleApiOther(httpMessage, OTHER_SET_PROXY, jSONObject);
            }
        }
        catch (URIException uRIException) {
            logger.error((Object)uRIException.getMessage(), (Throwable)uRIException);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, httpMessage.getRequestHeader().getURI().toString());
    }

    private String getPacFile(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("function FindProxyForURL(url, host) {\n");
        stringBuilder.append("  return \"PROXY ").append(string).append(':').append(n).append("\";\n");
        stringBuilder.append("} // End of function\n");
        return stringBuilder.toString();
    }

    private void getURLs(SiteNode siteNode, ApiResponseList apiResponseList) {
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            String string = siteNode2.getNodeName();
            if (string.indexOf("//") >= 0) {
                string = string.substring(string.indexOf("//") + 2);
            }
            try {
                apiResponseList.addItem(new ApiResponseElement("url", siteNode2.getHistoryReference().getURI().toString()));
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            this.getURLs(siteNode2, apiResponseList);
        }
    }

    private ApiResponseSet alertToSet(Alert alert) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_ID, String.valueOf(alert.getAlertId()));
        hashMap.put(VIEW_ALERT, alert.getAlert());
        hashMap.put("description", alert.getDescription());
        hashMap.put("risk", Alert.MSG_RISK[alert.getRisk()]);
        hashMap.put("confidence", Alert.MSG_CONFIDENCE[alert.getConfidence()]);
        hashMap.put("url", alert.getUri());
        hashMap.put("other", alert.getOtherInfo());
        hashMap.put("param", alert.getParam());
        hashMap.put("attack", alert.getAttack());
        hashMap.put("evidence", alert.getEvidence());
        hashMap.put("reference", alert.getReference());
        hashMap.put("cweid", String.valueOf(alert.getCweId()));
        hashMap.put("wascid", String.valueOf(alert.getWascId()));
        hashMap.put("solution", alert.getSolution());
        if (alert.getHistoryRef() != null) {
            hashMap.put("messageId", String.valueOf(alert.getHistoryRef().getHistoryId()));
        }
        return new ApiResponseSet(VIEW_ALERT, hashMap);
    }

    private void processAlerts(String string, int n, int n2, Processor<Alert> processor) throws ApiException {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        try {
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            Vector<Integer> vector = tableAlert.getAlertList();
            PaginationConstraintsChecker paginationConstraintsChecker = new PaginationConstraintsChecker(n, n2);
            for (int i = 0; i < vector.size(); ++i) {
                int n3 = vector.get(i);
                RecordAlert recordAlert = tableAlert.read(n3);
                Alert alert = new Alert(recordAlert);
                if (alert.getConfidence() == 0 || arrayList.contains(alert) || string != null && !alert.getUri().startsWith(string)) continue;
                paginationConstraintsChecker.recordProcessed();
                arrayList.add(alert);
                if (!paginationConstraintsChecker.hasPageStarted()) continue;
                processor.process(alert);
                if (!paginationConstraintsChecker.hasPageEnded()) {
                    continue;
                }
                break;
            }
        }
        catch (DatabaseException databaseException) {
            logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    private void processHttpMessages(String string, int n, int n2, Processor<RecordHistory> processor) throws ApiException {
        try {
            TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
            List<Integer> list = tableHistory.getHistoryIdsExceptOfHistType(Model.getSingleton().getSession().getSessionId(), 0);
            PaginationConstraintsChecker paginationConstraintsChecker = new PaginationConstraintsChecker(n, n2);
            for (Integer n3 : list) {
                RecordHistory recordHistory = tableHistory.read(n3);
                HttpMessage httpMessage = recordHistory.getHttpMessage();
                if (httpMessage.getRequestHeader().isImage() || httpMessage.getResponseHeader().isImage() || string != null && !httpMessage.getRequestHeader().getURI().toString().startsWith(string)) continue;
                paginationConstraintsChecker.recordProcessed();
                if (!paginationConstraintsChecker.hasPageStarted()) continue;
                processor.process(recordHistory);
                if (!paginationConstraintsChecker.hasPageEnded()) continue;
                break;
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    @Override
    public void sessionOpened(File file, Exception exception) {
    }

    @Override
    public void sessionSaved(Exception exception) {
        logger.debug((Object)"Saved session notification");
        this.savingSession = false;
    }

    @Override
    public void sessionSnapshot(Exception exception) {
        logger.debug((Object)"Snaphot session notification");
        this.savingSession = false;
    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;

        public PaginationConstraintsChecker(int n, int n2) {
            if (n > 0) {
                this.pageStarted = false;
                this.startRecord = n;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (n2 > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? n + n2 - 1 : n2;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
        }

        public void recordProcessed() {
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }
    }

    private static class CounterProcessor<T>
    implements Processor<T> {
        private int count = 0;

        @Override
        public void process(T t) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static interface Processor<T> {
        public void process(T var1);
    }

    private static enum ScanReportType {
        HTML,
        XML;

    }
}

