/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.db.TableSession;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableSession
extends SqlAbstractTable
implements TableSession {
    private static final String SESSIONID = DbSQL.getSQL("session.field.sessionid");
    private static final String SESSIONNAME = DbSQL.getSQL("session.field.sessionname");
    private static final String LASTACCESS = DbSQL.getSQL("session.field.lastaccess");

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
    }

    @Override
    public synchronized void insert(long l, String string) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("session.ps.insert");
            sqlPreparedStatementWrapper.getPs().setLong(1, l);
            sqlPreparedStatementWrapper.getPs().setString(2, string);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public synchronized void update(long l, String string) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("session.ps.update");
            sqlPreparedStatementWrapper.getPs().setLong(2, l);
            sqlPreparedStatementWrapper.getPs().setString(1, string);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public List<RecordSession> listSessions() throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("session.ps.list");
            ArrayList<RecordSession> arrayList = new ArrayList<RecordSession>();
            try (Object object = sqlPreparedStatementWrapper.getPs().executeQuery();){
                RecordSession recordSession = this.build((ResultSet)object);
                while (recordSession != null) {
                    arrayList.add(recordSession);
                    recordSession = this.build((ResultSet)object);
                }
            }
            object = arrayList;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    private RecordSession build(ResultSet resultSet) throws DatabaseException {
        try {
            RecordSession recordSession = null;
            if (resultSet.next()) {
                recordSession = new RecordSession(resultSet.getLong(SESSIONID), resultSet.getString(SESSIONNAME), resultSet.getDate(LASTACCESS));
            }
            return recordSession;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }
}

