/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.authentication.AuthenticationMethod;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthenticationMethodIndicatorsUnitTest {
    private static final String LOGGED_OUT_COMPLEX_INDICATOR = "User [^\\s]* logged out";
    private static final String LOGGED_OUT_COMPLEX_BODY = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque auctor nulla id turpis placerat vulputate. User Test logged out.  Proin tempor bibendum eros rutrum. ";
    private static final String LOGGED_IN_INDICATOR = "logged in";
    private static final String LOGGED_OUT_INDICATOR = "logged out";
    private static final String LOGGED_IN_BODY = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque auctor nulla id turpis placerat vulputate.logged in Proin tempor bibendum eros rutrum. ";
    private static final String LOGGED_OUT_BODY = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque auctor nulla id turpis placerat vulputate.logged out Proin tempor bibendum eros rutrum. ";
    private HttpMessage loginMessage;
    private AuthenticationMethod method;

    @Before
    public void setUp() throws Exception {
        this.loginMessage = new HttpMessage();
        this.method = (AuthenticationMethod)Mockito.mock(AuthenticationMethod.class, (Answer)Mockito.CALLS_REAL_METHODS);
    }

    @Test
    public void shouldStoreSetLoggedInIndicator() {
        this.method.setLoggedInIndicatorPattern(LOGGED_IN_INDICATOR);
        Assert.assertEquals((Object)LOGGED_IN_INDICATOR, (Object)this.method.getLoggedInIndicatorPattern().pattern());
    }

    @Test
    public void shouldStoreSetLoggedOutIndicator() {
        this.method.setLoggedOutIndicatorPattern(LOGGED_OUT_INDICATOR);
        Assert.assertEquals((Object)LOGGED_OUT_INDICATOR, (Object)this.method.getLoggedOutIndicatorPattern().pattern());
    }

    @Test
    public void shouldNotStoreNullOrEmptyLoggedInIndicator() {
        this.method.setLoggedInIndicatorPattern(null);
        Assert.assertNull((Object)this.method.getLoggedInIndicatorPattern());
        this.method.setLoggedInIndicatorPattern("  ");
        Assert.assertNull((Object)this.method.getLoggedInIndicatorPattern());
    }

    @Test
    public void shouldNotStoreNullOrEmptyLoggedOutIndicator() {
        this.method.setLoggedOutIndicatorPattern(null);
        Assert.assertNull((Object)this.method.getLoggedOutIndicatorPattern());
        this.method.setLoggedOutIndicatorPattern("  ");
        Assert.assertNull((Object)this.method.getLoggedOutIndicatorPattern());
    }

    @Test
    public void shouldIdentifyLoggedInResponseBodyWhenLoggedInIndicatorIsSet() {
        this.method.setLoggedInIndicatorPattern(LOGGED_IN_INDICATOR);
        this.loginMessage.setResponseBody(LOGGED_IN_BODY);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldIdentifyLoggedOutResponseBodyWhenLoggedInIndicatorIsSet() {
        this.method.setLoggedInIndicatorPattern(LOGGED_IN_INDICATOR);
        this.loginMessage.setResponseBody(LOGGED_OUT_BODY);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldIdentifyLoggedInResponseHeaderWhenLoggedInIndicatorIsSet() {
        this.method.setLoggedInIndicatorPattern(LOGGED_IN_INDICATOR);
        this.loginMessage.getResponseHeader().addHeader("test", LOGGED_IN_INDICATOR);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldIdentifyLoggedOutResponseHeaderWhenLoggedInIndicatorIsSet() {
        this.method.setLoggedInIndicatorPattern(LOGGED_IN_INDICATOR);
        this.loginMessage.getResponseHeader().addHeader("test", LOGGED_OUT_INDICATOR);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldIdentifyLoggedOutResponseBodyWhenLoggedOutIndicatorIsSet() {
        this.method.setLoggedOutIndicatorPattern(LOGGED_OUT_INDICATOR);
        this.loginMessage.setResponseBody(LOGGED_OUT_BODY);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldIdentifyLoggedInResponseBodyWhenLoggedOutIndicatorIsSet() {
        this.method.setLoggedOutIndicatorPattern(LOGGED_OUT_INDICATOR);
        this.loginMessage.setResponseBody(LOGGED_IN_BODY);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldIdentifyLoggedOutResponseHeaderWhenLoggedOutIndicatorIsSet() {
        this.method.setLoggedOutIndicatorPattern(LOGGED_OUT_INDICATOR);
        this.loginMessage.getResponseHeader().addHeader("test", LOGGED_OUT_INDICATOR);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldIdentifyLoggedInResponseHeaderWhenLoggedOutIndicatorIsSet() {
        this.method.setLoggedOutIndicatorPattern(LOGGED_OUT_INDICATOR);
        this.loginMessage.getResponseHeader().addHeader("test", LOGGED_IN_INDICATOR);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldIdentifyLoggedOutResponseWithComplexRegex() {
        this.method.setLoggedOutIndicatorPattern(LOGGED_OUT_COMPLEX_INDICATOR);
        this.loginMessage.setResponseBody(LOGGED_OUT_COMPLEX_BODY);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldIdentifyLoggedInResponseWithComplexRegex() {
        this.method.setLoggedOutIndicatorPattern(LOGGED_OUT_COMPLEX_INDICATOR);
        this.loginMessage.setResponseBody(LOGGED_OUT_BODY);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldIdentifyResponseAsLoggedInWhenNoIndicatorIsSet() {
        this.loginMessage.setResponseBody(LOGGED_OUT_BODY);
        Assert.assertThat((Object)this.method.isAuthenticated(this.loginMessage), (Matcher)Matchers.is((Object)true));
    }
}

