/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.FileNotFoundException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.HeadlessBootstrap;

class DaemonBootstrap
extends HeadlessBootstrap {
    private final Logger logger = Logger.getLogger(DaemonBootstrap.class);

    public DaemonBootstrap(CommandLine commandLine) {
        super(commandLine);
    }

    @Override
    public int start() {
        int n = super.start();
        if (n != 0) {
            return n;
        }
        View.setDaemon(true);
        BasicConfigurator.configure();
        this.logger.info((Object)DaemonBootstrap.getStartingMessage());
        try {
            this.initModel();
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                System.out.println(Constant.messages.getString("start.db.error"));
                System.out.println(exception.getLocalizedMessage());
            }
            this.logger.fatal((Object)exception.getMessage(), (Throwable)exception);
            return 1;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Control control = DaemonBootstrap.this.initControl();
                DaemonBootstrap.this.warnAddOnsAndExtensionsNoLongerRunnable();
                if (!DaemonBootstrap.this.handleCmdLineSessionArgsSynchronously(control)) {
                    return;
                }
                try {
                    control.getExtensionLoader().hookCommandLineListener(DaemonBootstrap.this.getArgs());
                    control.runCommandLine();
                }
                catch (Exception exception) {
                    DaemonBootstrap.this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(100000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setName("ZAP-daemon");
        thread.start();
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }
}

