/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.MainFooterPanel;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.view.MainToolbarPanel;

public class MainFrame
extends AbstractFrame {
    private static final long serialVersionUID = -1430550461546083192L;
    private JPanel paneContent = null;
    private WorkbenchPanel paneStandard = null;
    private MainMenuBar mainMenuBar = null;
    private JPanel paneDisplay = null;
    private MainToolbarPanel mainToolbarPanel = null;
    private MainFooterPanel mainFooterPanel = null;
    private int displayOption = -1;

    public MainFrame(int n) {
        this.initialize();
        this.changeDisplayOption(n);
    }

    private void initialize() {
        this.setJMenuBar(this.getMainMenuBar());
        this.setContentPane(this.getPaneContent());
        this.setPreferredSize(new Dimension(1000, 800));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.getMainMenuBar().getMenuFileControl().exit();
            }
        });
        this.setVisible(false);
    }

    private JPanel getPaneContent() {
        if (this.paneContent == null) {
            this.paneContent = new JPanel();
            this.paneContent.setLayout(new BoxLayout(this.getPaneContent(), 1));
            this.paneContent.setEnabled(true);
            if (Model.getSingleton().getOptionsParam().getViewParam().getShowMainToolbar() == 1) {
                this.paneContent.add((Component)this.getMainToolbarPanel(), null);
            }
            this.paneContent.add((Component)this.getPaneDisplay(), null);
            this.paneContent.add((Component)this.getMainFooterPanel(), null);
        }
        return this.paneContent;
    }

    public WorkbenchPanel getWorkbench() {
        if (this.paneStandard == null) {
            this.paneStandard = new WorkbenchPanel(this.displayOption);
            this.paneStandard.setLayout(new CardLayout());
            this.paneStandard.setName("paneStandard");
        }
        return this.paneStandard;
    }

    public MainMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new MainMenuBar();
        }
        return this.mainMenuBar;
    }

    public JPanel getPaneDisplay() {
        if (this.paneDisplay == null) {
            this.paneDisplay = new JPanel();
            this.paneDisplay.setLayout(new CardLayout());
            this.paneDisplay.setName("paneDisplay");
            this.paneDisplay.add((Component)this.getWorkbench(), this.getWorkbench().getName());
        }
        return this.paneDisplay;
    }

    public MainToolbarPanel getMainToolbarPanel() {
        if (this.mainToolbarPanel == null) {
            this.mainToolbarPanel = new MainToolbarPanel();
        }
        return this.mainToolbarPanel;
    }

    public MainFooterPanel getMainFooterPanel() {
        if (this.mainFooterPanel == null) {
            this.mainFooterPanel = new MainFooterPanel();
        }
        return this.mainFooterPanel;
    }

    public void changeDisplayOption(int n) {
        if (this.displayOption != n) {
            this.displayOption = n;
            this.getWorkbench().changeDisplayOption(n);
            this.getMainToolbarPanel().setDisplayOption(n);
            Model.getSingleton().getOptionsParam().getViewParam().setDisplayOption(n);
        }
    }

    @Override
    public void setTitle(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(string);
            stringBuilder.append(" - ");
        }
        stringBuilder.append("OWASP ZAP").append(' ').append(Constant.PROGRAM_VERSION);
        super.setTitle(stringBuilder.toString());
    }
}

