/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.editor;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.cnd.makefile.editor.ShellEmbeddingProvider;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellEmbeddingHighlightContainer
extends AbstractHighlightsContainer {
    private final Document doc;
    private List<HighlightItem> highlights;

    public static ShellEmbeddingHighlightContainer get(Document doc) {
        ShellEmbeddingHighlightContainer l = (ShellEmbeddingHighlightContainer)((Object)doc.getProperty(ShellEmbeddingHighlightContainer.class));
        if (l == null) {
            l = new ShellEmbeddingHighlightContainer(doc);
            doc.putProperty(ShellEmbeddingHighlightContainer.class, (Object)l);
        }
        return l;
    }

    private ShellEmbeddingHighlightContainer(Document doc) {
        this.doc = doc;
        this.highlights = Collections.emptyList();
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        List<HighlightItem> highlightsCopy = this.highlights;
        return ShellHighlightSequence.create(highlightsCopy, startOffset, endOffset);
    }

    void setHighlights(final List<HighlightItem> newHighlights) {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            public void run() {
                int[] changedInterval = ShellEmbeddingHighlightContainer.changedInterval(ShellEmbeddingHighlightContainer.this.highlights, newHighlights);
                if (changedInterval != null) {
                    ShellEmbeddingHighlightContainer.this.highlights = newHighlights;
                    ShellEmbeddingHighlightContainer.this.fireHighlightsChange(changedInterval[0], changedInterval[1]);
                }
            }
        });
    }

    static int[] changedInterval(List<HighlightItem> oldHighlights, List<HighlightItem> newHighlights) {
        int oldSize = oldHighlights.size();
        int newSize = newHighlights.size();
        int minSize = Math.min(oldSize, newSize);
        int commonPrefix = 0;
        for (int i = 0; i < minSize && HighlightItem.equals(oldHighlights.get(i), newHighlights.get(i)); ++i) {
            ++commonPrefix;
        }
        if (oldSize == newSize && commonPrefix == newSize) {
            return null;
        }
        int commonSuffix = 0;
        for (int i = 0; i < minSize && HighlightItem.equals(oldHighlights.get(oldSize - 1 - i), newHighlights.get(newSize - 1 - i)); ++i) {
            ++commonSuffix;
        }
        int changeStart = commonPrefix == 0 ? 0 : oldHighlights.get(commonPrefix - 1).end.getOffset();
        int changeEnd = commonSuffix == 0 ? Integer.MAX_VALUE : oldHighlights.get(oldSize - commonSuffix).start.getOffset();
        return new int[]{changeStart, changeEnd};
    }

    static int firstOverlap(List<HighlightItem> highlights, int startOffset) {
        int left = 0;
        int right = highlights.size();
        while (left < right) {
            int mid = (left + right) / 2;
            HighlightItem midItem = highlights.get(mid);
            if (midItem.end.getOffset() <= startOffset) {
                left = mid + 1;
                continue;
            }
            if (startOffset < midItem.start.getOffset()) {
                right = mid;
                continue;
            }
            return mid;
        }
        return left;
    }

    static int lastOverlap(List<HighlightItem> highlights, int endOffset) {
        int left = -1;
        int right = highlights.size() - 1;
        while (left < right) {
            int mid = (left + right + 1) / 2;
            HighlightItem midItem = highlights.get(mid);
            int itemStart = midItem.start.getOffset();
            int itemEnd = midItem.end.getOffset();
            if (endOffset <= itemStart) {
                right = mid - 1;
                continue;
            }
            if (itemEnd < endOffset) {
                left = mid;
                continue;
            }
            return mid;
        }
        return left;
    }

    public static final class LayerFactory
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)ShellEmbeddingProvider.class.getName(), (ZOrder)ZOrder.SYNTAX_RACK, (boolean)false, (HighlightsContainer)ShellEmbeddingHighlightContainer.get(context.getDocument()))};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ShellHighlightSequence
    implements HighlightsSequence {
        private static final FontColorSettings SETTINGS = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/sh")).lookup(FontColorSettings.class);
        private final Iterator<HighlightItem> highlightIterator;
        private HighlightItem currentItem;

        private static HighlightsSequence create(List<HighlightItem> highlights, int startOffset, int endOffset) {
            int endIdx;
            int startIdx;
            if (startOffset < endOffset) {
                startIdx = ShellEmbeddingHighlightContainer.firstOverlap(highlights, startOffset);
                endIdx = ShellEmbeddingHighlightContainer.lastOverlap(highlights, endOffset) + 1;
            } else {
                startIdx = highlights.size();
                endIdx = 0;
            }
            if (startIdx < endIdx) {
                return new ShellHighlightSequence(highlights.subList(startIdx, endIdx).iterator());
            }
            return HighlightsSequence.EMPTY;
        }

        private ShellHighlightSequence(Iterator<HighlightItem> highlightIterator) {
            this.highlightIterator = highlightIterator;
        }

        public boolean moveNext() {
            boolean hasNext = this.highlightIterator.hasNext();
            this.currentItem = hasNext ? this.highlightIterator.next() : null;
            return hasNext;
        }

        public int getStartOffset() {
            if (this.currentItem == null) {
                throw new NoSuchElementException();
            }
            return this.currentItem.start.getOffset();
        }

        public int getEndOffset() {
            if (this.currentItem == null) {
                throw new NoSuchElementException();
            }
            return this.currentItem.end.getOffset();
        }

        public AttributeSet getAttributes() {
            if (this.currentItem == null) {
                throw new NoSuchElementException();
            }
            return SETTINGS.getTokenFontColors(this.currentItem.category);
        }
    }

    public static final class HighlightItem {
        private final Position start;
        private final Position end;
        private final String category;

        public HighlightItem(Position start, Position end, String category) {
            this.start = start;
            this.end = end;
            this.category = category;
        }

        private static boolean equals(HighlightItem a, HighlightItem b) {
            return a.start.getOffset() == b.start.getOffset() && a.end.getOffset() == b.end.getOffset() && a.category.equals(b.category);
        }
    }
}

