/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.util.logging.LogRecord;

public final class ProjectOp {
    private final String name;
    private final String type;
    private final boolean startup;
    private final int number;

    private ProjectOp(String name, String type, int number, boolean startup) {
        this.name = ProjectOp.fixName(name, true);
        this.type = ProjectOp.fixName(type, false);
        this.number = number;
        this.startup = startup;
    }

    private static String fixName(String name, boolean isDisplayName) {
        if (isDisplayName) {
            if (name.indexOf("Maven") >= 0) {
                return "Maven";
            }
            if (name.endsWith("Project")) {
                return name.substring(0, name.length() - 7);
            }
        }
        return name;
    }

    public String getProjectDisplayName() {
        return this.name;
    }

    public String getProjectType() {
        return this.type;
    }

    public int getDelta() {
        return this.number;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public static ProjectOp valueOf(LogRecord rec) {
        if ("UI_CLOSED_PROJECTS".equals(rec.getMessage())) {
            int cnt;
            String type = ProjectOp.getStringParam(rec, 0, "unknown");
            String name = ProjectOp.getStringParam(rec, 1, "unknown");
            try {
                cnt = Integer.parseInt(ProjectOp.getStringParam(rec, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(name, type, -cnt, false);
        }
        if ("UI_OPEN_PROJECTS".equals(rec.getMessage())) {
            int cnt;
            String type = ProjectOp.getStringParam(rec, 0, "unknown");
            String name = ProjectOp.getStringParam(rec, 1, "unknown");
            try {
                cnt = Integer.parseInt(ProjectOp.getStringParam(rec, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(name, type, cnt, false);
        }
        if ("UI_INIT_PROJECTS".equals(rec.getMessage())) {
            int cnt;
            String type = ProjectOp.getStringParam(rec, 0, "unknown");
            String name = ProjectOp.getStringParam(rec, 1, "unknown");
            try {
                cnt = Integer.parseInt(ProjectOp.getStringParam(rec, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(name, type, cnt, true);
        }
        return null;
    }

    private static String getStringParam(LogRecord rec, int index, String def) {
        if (rec == null) {
            return def;
        }
        Object[] params = rec.getParameters();
        if (params == null || params.length <= index) {
            return def;
        }
        if (params[index] instanceof String) {
            return (String)params[index];
        }
        return def;
    }
}

