/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;

class IniSource {
    public static final char INCLUDE_BEGIN = '<';
    public static final char INCLUDE_END = '>';
    public static final char INCLUDE_OPTIONAL = '?';
    private static final String EMPTY = "";
    protected final boolean allowInclude;
    protected final String commentChars;
    private URL _base;
    private IniSource _chain;
    private final LineNumberReader _reader;

    protected IniSource(InputStream input, boolean includeFlag, String comments) {
        this._reader = new LineNumberReader(new InputStreamReader(input));
        this.allowInclude = includeFlag;
        this.commentChars = comments;
    }

    protected IniSource(Reader input, boolean includeFlag, String comments) {
        this._reader = new LineNumberReader(input);
        this.allowInclude = includeFlag;
        this.commentChars = comments;
    }

    protected IniSource(URL input, boolean includeFlag, String comments) throws IOException {
        this._base = input;
        this._reader = new LineNumberReader(new InputStreamReader(input.openStream()));
        this.allowInclude = includeFlag;
        this.commentChars = comments;
    }

    protected int getLineNumber() {
        return this._reader.getLineNumber();
    }

    protected void close() throws IOException {
        this._reader.close();
    }

    protected String readLine() throws IOException {
        String line;
        if (this._chain == null) {
            line = this.readLineLocal();
        } else {
            line = this._chain.readLine();
            if (line == null) {
                this._chain = null;
                line = this.readLine();
            }
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleInclude(String input) throws IOException {
        String line = input;
        if (this.allowInclude && line.length() > 2 && line.charAt(0) == '<' && line.charAt(line.length() - 1) == '>') {
            URL loc;
            boolean optional;
            boolean bl = optional = (line = line.substring(1, line.length() - 1).trim()).charAt(0) == '?';
            if (optional) {
                line = line.substring(1).trim();
            }
            URL uRL = loc = this._base == null ? new URL(line) : new URL(this._base, line);
            if (optional) {
                try {
                    this._chain = new IniSource(loc, this.allowInclude, this.commentChars);
                }
                catch (IOException x) {
                }
                finally {
                    line = this.readLine();
                }
            } else {
                this._chain = new IniSource(loc, this.allowInclude, this.commentChars);
                line = this.readLine();
            }
        }
        return line;
    }

    private String readLineLocal() throws IOException {
        String line = this.readLineLocalOne();
        while (line != null && line.length() == 0) {
            line = this.readLineLocalOne();
        }
        if (line == null) {
            this.close();
        } else {
            line = this.handleInclude(line);
        }
        return line;
    }

    private String readLineLocalOne() throws IOException {
        String line = this._reader.readLine();
        if (line != null && (line = line.trim()).length() != 0 && this.commentChars.indexOf(line.charAt(0)) >= 0) {
            line = EMPTY;
        }
        return line;
    }
}

