/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

final class JavadocCompletionUtils {
    static final Pattern JAVADOC_LINE_BREAK = Pattern.compile("\\n[ \\t]*\\**[ \\t]*\\z");
    static final Pattern JAVADOC_WHITE_SPACE = Pattern.compile("[^ \\t]");
    static final Pattern JAVADOC_EMPTY = Pattern.compile("(\\s*\\**\\s*\n)*\\s*\\**\\s*");
    static final Pattern JAVADOC_FIRST_WHITE_SPACE = Pattern.compile("[ \\t]*\\**[ \\t]*");
    private static Set<JavaTokenId> IGNORE_TOKES = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT);
    private static final Logger LOGGER = Logger.getLogger(JavadocCompletionUtils.class.getName());
    private static final int MAX_DUMPS = 255;

    JavadocCompletionUtils() {
    }

    public static boolean isJavadocContext(final Document document, final int n) {
        final boolean[] blArray = new boolean[]{false};
        document.render(new Runnable(){

            @Override
            public void run() {
                blArray[0] = JavadocCompletionUtils.isJavadocContext(TokenHierarchy.get((Document)document), n);
            }
        });
        return blArray[0];
    }

    static boolean isJavadocContext(TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)tokenHierarchy, (int)n);
        if (!JavadocCompletionUtils.movedToJavadocToken((TokenSequence<JavaTokenId>)tokenSequence, n)) {
            return false;
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(JavadocTokenId.language());
        if (tokenSequence2 == null) {
            return false;
        }
        if (tokenSequence2.isEmpty()) {
            return JavadocCompletionUtils.isEmptyJavadoc((Token<JavaTokenId>)tokenSequence.token(), n - tokenSequence.offset());
        }
        tokenSequence2.move(n);
        if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
            return false;
        }
        return JavadocCompletionUtils.isInsideToken(tokenSequence2, n) && !JavadocCompletionUtils.isInsideIndent((Token<JavadocTokenId>)tokenSequence2.token(), n - tokenSequence2.offset());
    }

    public static Doc findJavadoc(CompilationInfo compilationInfo, Document document, int n) {
        Doc doc;
        Object object;
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)compilationInfo.getTokenHierarchy(), (int)n);
        if (tokenSequence == null || !JavadocCompletionUtils.movedToJavadocToken((TokenSequence<JavaTokenId>)tokenSequence, n)) {
            return null;
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(JavadocTokenId.language());
        int n2 = tokenSequence.offset() + tokenSequence.token().length();
        while (tokenSequence.moveNext()) {
            object = tokenSequence.token().id();
            if (object == JavaTokenId.BLOCK_COMMENT && "/**/".contentEquals(tokenSequence.token().text())) {
                return null;
            }
            if (IGNORE_TOKES.contains(object)) continue;
            n2 = tokenSequence.offset();
            ++n2;
            break;
        }
        object = compilationInfo.getTreeUtilities().pathFor(n2);
        Tree tree = ((TreePath)object).getLeaf();
        Tree.Kind kind = tree.getKind();
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        while (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD && kind != Tree.Kind.VARIABLE && kind != Tree.Kind.COMPILATION_UNIT) {
            if ((object = ((TreePath)object).getParentPath()) == null) {
                tree = null;
                kind = null;
                break;
            }
            tree = ((TreePath)object).getLeaf();
            kind = tree.getKind();
        }
        if (tree == null || kind == Tree.Kind.COMPILATION_UNIT || sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree) < (long)n) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement((TreePath)object);
        Doc doc2 = doc = element != null ? compilationInfo.getElementUtilities().javaDocFor(element) : null;
        if (JavadocCompletionUtils.isInvalidDocInstance(doc, (TokenSequence<JavadocTokenId>)tokenSequence2)) {
            JavadocCompletionUtils.dumpOutOfSyncError(compilationInfo.getSnapshot(), n, tree, element, (TokenSequence<JavadocTokenId>)tokenSequence2, doc, false);
            doc = null;
        }
        return doc;
    }

    static TokenSequence<JavadocTokenId> findJavadocTokenSequence(CompilationInfo compilationInfo, int n) {
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)compilationInfo.getTokenHierarchy(), (int)n);
        if (tokenSequence == null || !JavadocCompletionUtils.movedToJavadocToken((TokenSequence<JavaTokenId>)tokenSequence, n)) {
            return null;
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(JavadocTokenId.language());
        if (tokenSequence2 == null) {
            return null;
        }
        tokenSequence2.move(n);
        return tokenSequence2;
    }

    static TokenSequence<JavadocTokenId> findJavadocTokenSequence(CompilationInfo compilationInfo, Tree tree, Element element) {
        if (element == null || compilationInfo.getElementUtilities().isSynthetic(element)) {
            return null;
        }
        if (tree == null) {
            tree = compilationInfo.getTrees().getTree(element);
        }
        if (tree == null) {
            return null;
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)compilationInfo.getTokenHierarchy(), (int)n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        Token token = null;
        while (tokenSequence.movePrevious() && ((token = tokenSequence.token()).id() != JavaTokenId.BLOCK_COMMENT || !"/**/".contentEquals(token.text())) && IGNORE_TOKES.contains(token.id())) {
        }
        if (token == null || token.id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        if (compilationInfo.getElements().getDocComment(element) == null) {
            return null;
        }
        return tokenSequence.embedded(JavadocTokenId.language());
    }

    static boolean isInsideIndent(Token<JavadocTokenId> token, int n) {
        int n2 = -1;
        if (token.id() == JavadocTokenId.OTHER_TEXT) {
            CharSequence charSequence = token.text();
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if (c == '\n') {
                    if (i > n) break;
                    n2 = -1;
                    if (i >= n) break;
                    continue;
                }
                if (i == 0) break;
                if (c != '*' || n2 >= 0) continue;
                n2 = i;
                if (n <= i) break;
            }
        }
        return n2 >= n;
    }

    public static boolean isLineBreak(Token<JavadocTokenId> token) {
        return JavadocCompletionUtils.isLineBreak(token, token.length());
    }

    public static boolean isLineBreak(Token<JavadocTokenId> token, int n) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        if (n < 0 || n > token.length()) {
            throw new IndexOutOfBoundsException("pos: " + n + ", token.length: " + token.length());
        }
        CharSequence charSequence = token.text();
        boolean bl = n > 0 && JAVADOC_LINE_BREAK.matcher(charSequence.subSequence(0, n)).find() && (n == token.length() || !JavadocCompletionUtils.isInsideIndent(token, n));
        return bl;
    }

    public static boolean isWhiteSpace(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0 && !JAVADOC_WHITE_SPACE.matcher(charSequence).find();
    }

    public static boolean isWhiteSpace(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence charSequence = token.text();
        boolean bl = !JAVADOC_WHITE_SPACE.matcher(charSequence).find();
        return bl;
    }

    public static boolean isFirstWhiteSpaceAtFirstLine(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence charSequence = token.text();
        boolean bl = JAVADOC_FIRST_WHITE_SPACE.matcher(charSequence).matches();
        return bl;
    }

    public static boolean isWhiteSpaceFirst(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT || token.length() < 1) {
            return false;
        }
        CharSequence charSequence = token.text();
        char c = charSequence.charAt(0);
        return c == ' ' || c == '\t';
    }

    public static boolean isWhiteSpaceLast(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT || token.length() < 1) {
            return false;
        }
        CharSequence charSequence = token.text();
        char c = charSequence.charAt(charSequence.length() - 1);
        return c == ' ' || c == '\t';
    }

    public static boolean isInlineTagStart(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence charSequence = token.text();
        boolean bl = charSequence.charAt(charSequence.length() - 1) == '{';
        return bl;
    }

    public static boolean isBlockTag(Tag tag) {
        Doc doc = tag.holder();
        Tag[] tagArray = doc.tags();
        for (int i = 0; i < tagArray.length; ++i) {
            if (tag != tagArray[i]) continue;
            return true;
        }
        return false;
    }

    static CharSequence getCharSequence(Document document) {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            try {
                charSequence = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                throw (IndexOutOfBoundsException)new IndexOutOfBoundsException().initCause(badLocationException);
            }
        }
        return charSequence;
    }

    static CharSequence getCharSequence(Document document, int n, int n2) {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence != null) {
            charSequence = charSequence.subSequence(n, n2);
        } else {
            try {
                charSequence = document.getText(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                throw (IndexOutOfBoundsException)new IndexOutOfBoundsException().initCause(badLocationException);
            }
        }
        return charSequence;
    }

    private static boolean isInsideToken(TokenSequence<?> tokenSequence, int n) {
        return n >= tokenSequence.offset() && n <= tokenSequence.offset() + tokenSequence.token().length();
    }

    private static boolean movedToJavadocToken(TokenSequence<JavaTokenId> tokenSequence, int n) {
        if (tokenSequence == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        if (tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return false;
        }
        return JavadocCompletionUtils.isInsideToken(tokenSequence, n);
    }

    private static boolean isEmptyJavadoc(Token<JavaTokenId> token, int n) {
        if (token != null && token.id() == JavaTokenId.JAVADOC_COMMENT) {
            CharSequence charSequence = token.text();
            return n == 3 && "/***/".contentEquals(charSequence);
        }
        return false;
    }

    static boolean isInvalidDocInstance(Doc doc, TokenSequence<JavadocTokenId> tokenSequence) {
        if (doc != null && doc.getRawCommentText().trim().length() == 0 && !tokenSequence.isEmpty()) {
            tokenSequence.moveStart();
            return !tokenSequence.moveNext() || !JavadocCompletionUtils.isTokenOfEmptyJavadoc((Token<JavadocTokenId>)tokenSequence.token()) || tokenSequence.moveNext();
        }
        return false;
    }

    static boolean isTokenOfEmptyJavadoc(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        return JAVADOC_EMPTY.matcher(token.text()).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpOutOfSyncError(Snapshot snapshot, int n, Tree tree, Element element, TokenSequence<JavadocTokenId> tokenSequence, Doc doc, boolean bl) {
        IllegalStateException illegalStateException;
        boolean bl2;
        String string;
        String string2;
        block21: {
            string2 = System.getProperty("netbeans.user") + "/var/log/";
            string = ".jddump";
            FileObject fileObject = snapshot.getSource().getFileObject();
            Document document = snapshot.getSource().getDocument(false);
            String string3 = "<unknown>";
            try {
                string3 = fileObject.getURL().toURI().toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.log(Level.INFO, null, uRISyntaxException);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOGGER.log(Level.INFO, null, fileStateInvalidException);
            }
            String string4 = fileObject.getName();
            File file = new File(string2 + string4 + string);
            bl2 = false;
            for (int i = 1; i < 255 && file.exists(); ++i) {
                file = new File(string2 + string4 + '_' + i + string);
            }
            illegalStateException = new IllegalStateException("Please attach dump file " + file.toURI().toASCIIString() + " to bug.");
            if (!file.exists()) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                    try {
                        printWriter.printf("Out of sync error: source file %s\n", string3);
                        printWriter.println("----- Element: -------------------------------------------------------");
                        if (element != null) {
                            printWriter.printf("kind: %s, %s\n", new Object[]{element.getKind(), element});
                        } else {
                            printWriter.println("null");
                        }
                        printWriter.println("----- Tree: -------------------------------------------------------");
                        if (tree != null) {
                            printWriter.printf("kind: %s\n %s\n", new Object[]{tree.getKind(), tree});
                        } else {
                            printWriter.println("null");
                        }
                        printWriter.println("----- Offset: -------------------------------------------------------");
                        printWriter.printf("offset: %s\n", n);
                        printWriter.println("----- Token sequence: ----------------------------------------");
                        printWriter.println(tokenSequence);
                        printWriter.println("----- Doc instance: -------------------------------------------------------");
                        printWriter.printf("class: %s, toString: %s,\nraw text:'%s'\n", doc.getClass(), doc, doc.getRawCommentText());
                        printWriter.println("----- Stack trace: ---------------------------------------------");
                        illegalStateException.printStackTrace(printWriter);
                        printWriter.println("----- Source file content/snapshot: ----------------------------------------");
                        printWriter.println(snapshot.getText());
                        printWriter.println("----- Document content: ----------------------------------------");
                        try {
                            if (document != null) {
                                printWriter.println(document.getText(0, document.getLength()));
                                break block21;
                            }
                            printWriter.println("doc: null");
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.log(Level.INFO, null, badLocationException);
                        }
                    }
                    finally {
                        printWriter.close();
                        bl2 = true;
                    }
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, "Error when writing javadoc dump file!", iOException);
                }
            }
        }
        if (bl2) {
            if (bl) {
                throw illegalStateException;
            }
            LOGGER.log(Level.SEVERE, null, illegalStateException);
        } else {
            LOGGER.log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to ''{0}'' and clean all *{1} files in that directory.", new Object[]{string2, string});
            if (bl) {
                throw illegalStateException;
            }
        }
    }

    static void dumpOutOfSyncError(Snapshot snapshot, TokenSequence<JavadocTokenId> tokenSequence, Doc doc, boolean bl) {
        JavadocCompletionUtils.dumpOutOfSyncError(snapshot, JavadocCompletionUtils.dumpOffset(tokenSequence), null, null, tokenSequence, doc, bl);
    }

    static void dumpOutOfSyncError(CompilationInfo compilationInfo, TokenSequence<JavadocTokenId> tokenSequence, Doc doc, boolean bl) {
        Element element = compilationInfo.getElementUtilities().elementFor(doc);
        Tree tree = element != null ? compilationInfo.getTrees().getTree(element) : null;
        JavadocCompletionUtils.dumpOutOfSyncError(compilationInfo.getSnapshot(), JavadocCompletionUtils.dumpOffset(tokenSequence), tree, element, tokenSequence, doc, bl);
    }

    private static int dumpOffset(TokenSequence<JavadocTokenId> tokenSequence) {
        int n = -1;
        if (!tokenSequence.isEmpty()) {
            tokenSequence.moveStart();
            tokenSequence.moveNext();
            n = tokenSequence.offset();
        }
        return n;
    }
}

