/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.kenai.api.KenaiService;

public final class KenaiNotification {
    private Date stamp;
    private KenaiService.Type type;
    private URI uri;
    private String author;
    private String service;
    private String feature;
    private List<Modification> modifications;

    public KenaiNotification(Date stamp, KenaiService.Type type, URI uri, String author, String service, String featureName, List<Modification> modifications) {
        this.stamp = stamp;
        this.type = type;
        this.uri = uri;
        this.author = author;
        this.service = service;
        this.modifications = Collections.unmodifiableList(modifications);
        this.feature = featureName;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getStamp() {
        return this.stamp;
    }

    public KenaiService.Type getType() {
        return this.type;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getServiceName() {
        return this.service;
    }

    public String getFeatureName() {
        return this.feature;
    }

    public static final class Modification {
        private String resource;
        private String id;
        private Type type;

        public Modification(String resource, String id, Type type) {
            this.resource = resource;
            this.id = id;
            this.type = type;
        }

        public String getResource() {
            return this.resource;
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public static enum Type {
            NEW,
            CHANGE,
            DELETE,
            UNKNOWN;

        }
    }
}

