/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.platform.gems.Gem;

final class GemListParser {
    private static final Logger LOGGER = Logger.getLogger(GemListParser.class.getName());

    private GemListParser() {
    }

    static List<Gem> parseLocal(List<? extends String> output) {
        return GemListParser.parse(output, true);
    }

    static List<Gem> parseRemote(List<? extends String> output) {
        return GemListParser.parse(output, false);
    }

    private static List<Gem> parse(List<? extends String> output, boolean local) {
        LOGGER.finer("Going to parse Gem list");
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Using the following output:");
            LOGGER.finest("=== Output Start ===");
            for (String string : output) {
                LOGGER.finest(string);
            }
            LOGGER.finest("=== Output End ===");
        }
        Gem gem = null;
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        for (String string : output) {
            if (string.length() == 0 || Character.isWhitespace(string.charAt(0))) {
                if (gem == null) continue;
                String description = string.trim();
                if (gem.getDescription() == null) {
                    gem.setDescription(description);
                    continue;
                }
                gem.setDescription(gem.getDescription() + "\n" + description);
                continue;
            }
            if (string.charAt(0) == '.') continue;
            int versionIndex = string.indexOf(40);
            if (versionIndex != -1) {
                String name = string.substring(0, versionIndex).trim();
                int endIndex = string.indexOf(41);
                String versions = endIndex != -1 ? string.substring(versionIndex + 1, endIndex) : string.substring(versionIndex);
                gem = new Gem(name, local ? versions : null, local ? null : versions);
                arrayList.add(gem);
                continue;
            }
            gem = null;
        }
        LOGGER.finer("Parsed " + arrayList.size() + " gems");
        return arrayList;
    }
}

