/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpointEvent;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpointListener;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.models.BreakpointsNodeModel;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerOutput;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.IOManager;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
CndBreakpointListener,
PropertyChangeListener {
    private static final Pattern fileNamePattern = Pattern.compile("\\{fileName\\}");
    private static final Pattern functionNamePattern = Pattern.compile("\\{functionName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final Pattern addressPattern = Pattern.compile("\\{address\\}");
    private IOManager ioManager;
    private GdbDebugger debugger;
    private ContextProvider contextProvider;
    private final Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.ioManager = null;
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(CndBreakpointEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getDebugger() != this.debugger) {
                return;
            }
        }
        if (event.getConditionResult() == 2) {
            return;
        }
        CndBreakpoint breakpoint = (CndBreakpoint)event.getSource();
        if (breakpoint.getSuspend() != 0) {
            this.getBreakpointsNodeModel().setCurrentBreakpoint(breakpoint);
            this.debugger.setCurrentBreakpoint(breakpoint);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ioManager == null) {
                this.lookupIOManager();
                if (this.ioManager == null) {
                    return;
                }
            }
        }
        String printText = breakpoint.getPrintText();
        if (printText == null || printText.length() == 0) {
            return;
        }
        printText = this.substitute(printText, event);
        Object object3 = this.lock;
        synchronized (object3) {
            if (this.ioManager != null) {
                this.ioManager.println(printText, null);
            }
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object object = this.lock;
        synchronized (object) {
            if (this.debugger == null || !evt.getPropertyName().equals("state") || this.debugger.getState() == GdbDebugger.State.STOPPED) {
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
        this.debugger.setCurrentBreakpoint(null);
    }

    private String substitute(String printText, CndBreakpointEvent event) {
        Object o = event.getSource();
        if (o instanceof LineBreakpoint) {
            LineBreakpoint lpb = (LineBreakpoint)o;
            String name = lpb.getPath();
            String lnum = Integer.toString(lpb.getLineNumber());
            printText = fileNamePattern.matcher(printText).replaceAll(name);
            printText = lineNumberPattern.matcher(printText).replaceAll(lnum);
        } else if (o instanceof FunctionBreakpoint) {
            FunctionBreakpoint fbp = (FunctionBreakpoint)o;
            String functionName = fbp.getFunctionName();
            printText = functionNamePattern.matcher(printText).replaceAll(functionName);
        } else if (o instanceof AddressBreakpoint) {
            AddressBreakpoint abp = (AddressBreakpoint)o;
            String address = abp.getAddress();
            printText = addressPattern.matcher(printText).replaceAll(address);
        }
        Throwable thr = event.getConditionException();
        if (thr != null) {
            printText = printText + "\n***\n" + thr.getLocalizedMessage() + "\n***\n";
        }
        return printText;
    }

    private void lookupIOManager() {
        List lamls = this.contextProvider.lookup(null, LazyActionsManagerListener.class);
        for (LazyActionsManagerListener o : lamls) {
            if (!(o instanceof DebuggerOutput)) continue;
            this.ioManager = ((DebuggerOutput)o).getIOManager();
            break;
        }
    }

    private void hookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.hookBreakpoint(bpt);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.unhookBreakpoint(bpt);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof CndBreakpoint) {
            CndBreakpoint gdbBreakpoint = (CndBreakpoint)breakpoint;
            gdbBreakpoint.addCndBreakpointListener((CndBreakpointListener)this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof CndBreakpoint) {
            CndBreakpoint jpdaBreakpoint = (CndBreakpoint)breakpoint;
            jpdaBreakpoint.removeCndBreakpointListener((CndBreakpointListener)this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List l = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            for (NodeModel nm : l) {
                if (!(nm instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nm;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

