/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class HyperlinkEnv {
    private BaseDocument baseDocument;
    private String attribName;
    private String valueString;
    private int offset;
    private FileObject fileObject;
    private Map<String, String> declaredNamespaces;
    private int tokenStartOffset;
    private int tokenEndOffset;
    private String tokenImage;
    private int beanTagOffset;
    private String tagName;
    private Map<String, String> beanAttribs;
    private Type type = Type.NONE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperlinkEnv(Document document, int offset) {
        this.baseDocument = (BaseDocument)document;
        this.fileObject = NbEditorUtilities.getFileObject((Document)this.baseDocument);
        this.offset = offset;
        this.baseDocument.readLock();
        try {
            this.initialize();
        }
        finally {
            this.baseDocument.readUnlock();
        }
    }

    private void initialize() {
        Tag currentTag = null;
        DocumentContext documentContext = DocumentContext.create((Document)this.baseDocument, this.offset);
        if (documentContext == null) {
            return;
        }
        this.declaredNamespaces = documentContext.getDeclaredNamespacesMap();
        TokenItem token = documentContext.getCurrentToken();
        if (token == null) {
            return;
        }
        this.tokenStartOffset = token.getOffset();
        this.tokenEndOffset = this.tokenStartOffset + token.getImage().length();
        this.tokenImage = token.getImage();
        if (ContextUtilities.isValueToken(token) || ContextUtilities.isAttributeToken(documentContext.getCurrentToken())) {
            SyntaxElement element = documentContext.getCurrentElement();
            if (!(element instanceof Tag)) {
                return;
            }
            currentTag = (Tag)element;
            Tag beanTag = (Tag)SpringXMLConfigEditorUtils.getBean((Node)currentTag);
            if (beanTag != null) {
                this.beanTagOffset = beanTag.getElementOffset();
                this.beanAttribs = this.collectAttributes(beanTag);
            }
            this.tagName = currentTag.getNodeName();
        }
        if (ContextUtilities.isValueToken(token)) {
            this.type = Type.ATTRIB_VALUE;
            this.attribName = ContextUtilities.getAttributeTokenImage(documentContext);
            this.valueString = token.getImage();
            this.valueString = this.valueString.substring(1, this.valueString.length() - 1);
        } else if (ContextUtilities.isAttributeToken(documentContext.getCurrentToken())) {
            this.type = Type.ATTRIB;
            this.attribName = token.getImage();
        }
    }

    private Map<String, String> collectAttributes(Tag currentTag) {
        HashMap<String, String> attribsMap = new HashMap<String, String>();
        NamedNodeMap attribsNodeMap = currentTag.getAttributes();
        for (int i = 0; i < attribsNodeMap.getLength(); ++i) {
            Node n = attribsNodeMap.item(i);
            attribsMap.put(n.getNodeName(), n.getNodeValue());
        }
        return Collections.unmodifiableMap(attribsMap);
    }

    public String getAttribName() {
        return this.attribName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getValueString() {
        return this.valueString;
    }

    public Type getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public int getTokenStartOffset() {
        return this.tokenStartOffset;
    }

    public int getTokenEndOffset() {
        return this.tokenEndOffset;
    }

    public String getTokenImage() {
        return this.tokenImage;
    }

    public Map<String, String> getBeanAttributes() {
        return this.beanAttribs;
    }

    public int getBeanTagOffset() {
        return this.beanTagOffset;
    }

    public String lookupNamespacePrefix(String prefix) {
        return this.declaredNamespaces.get(prefix);
    }

    public static enum Type {
        ATTRIB_VALUE,
        ATTRIB,
        TEXT,
        NONE;


        public boolean isValueHyperlink() {
            return this == ATTRIB_VALUE;
        }

        public boolean isAttributeHyperlink() {
            return this == ATTRIB;
        }
    }
}

