/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class ValidBasicType
extends JPAEntityAttributeCheck {
    private static Collection<String> fixedBasicTypes = new TreeSet<String>(Arrays.asList("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "byte", "char", "short", "int", "long", "float", "double", "java.lang.Float", "java.lang.Double", "java.util.Date", "java.util.Calendar", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "byte[]", "java.lang.Byte[]", "char[]", "java.lang.Character[]"));

    @Override
    public ErrorDescription[] check(JPAProblemContext jPAProblemContext, AttributeWrapper attributeWrapper) {
        if (!(attributeWrapper.getModelElement() instanceof Basic)) {
            return null;
        }
        TreeUtilities treeUtilities = jPAProblemContext.getCompilationInfo().getTreeUtilities();
        Types types = jPAProblemContext.getCompilationInfo().getTypes();
        TypeMirror typeMirror = attributeWrapper.getType();
        TypeMirror typeMirror2 = treeUtilities.parseType("java.io.Serializable", jPAProblemContext.getJavaClass());
        TypeMirror typeMirror3 = treeUtilities.parseType("java.lang.Enum", jPAProblemContext.getJavaClass());
        TypeMirror typeMirror4 = treeUtilities.parseType("java.util.Collection", jPAProblemContext.getJavaClass());
        if (types.isAssignable(typeMirror, typeMirror2) || types.isAssignable(typeMirror, typeMirror3) || types.isAssignable(typeMirror, typeMirror4)) {
            return null;
        }
        for (String string : fixedBasicTypes) {
            TypeMirror typeMirror5 = treeUtilities.parseType(string, jPAProblemContext.getJavaClass());
            if (typeMirror5 == null || !types.isSameType(typeMirror, typeMirror5)) continue;
            return null;
        }
        if (Utilities.hasAnnotation(attributeWrapper.getJavaElement(), "javax.persistence.ElementCollection")) {
            return null;
        }
        return new ErrorDescription[]{Rule.createProblem(attributeWrapper.getJavaElement(), jPAProblemContext, NbBundle.getMessage(ValidBasicType.class, (String)"MSG_ValidBasicType"))};
    }
}

