/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.model;

import java.util.Collection;
import java.util.Iterator;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.JPAAnnotations;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Attributes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;

public class JPAHelper {
    public static boolean isAnyMemberAnnotatedAsIdOrEmbeddedId(Object object) {
        Attributes attributes = null;
        if (object instanceof Entity) {
            attributes = ((Entity)object).getAttributes();
        } else if (object instanceof MappedSuperclass) {
            attributes = ((MappedSuperclass)object).getAttributes();
        }
        if (attributes != null) {
            if (attributes.getEmbeddedId() != null) {
                return true;
            }
            if (attributes.getId().length > 0) {
                return true;
            }
        }
        return false;
    }

    public static String getPrimaryTableName(Entity entity) {
        return entity.getTable().getName();
    }

    public static AnnotationMirror getFirstAnnotationFromGivenSet(Element element, Collection<String> collection) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String string = annotationMirror.getAnnotationType().toString();
            if (!collection.contains(string)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AccessType findAccessType(TypeElement typeElement, Object object) {
        Object object2;
        Object object3;
        AccessType accessType = AccessType.INDETERMINED;
        if (object instanceof Entity) {
            object3 = ((Entity)object).getAccess();
            if ("FIELD".equals(object3)) {
                accessType = AccessType.FIELD;
            } else if ("PROPERTY".equals(object3)) {
                accessType = AccessType.PROPERTY;
            }
        }
        for (Element object4 : typeElement.getEnclosedElements()) {
            if (object4.getKind() != ElementKind.FIELD && object4.getKind() != ElementKind.METHOD || (object2 = JPAHelper.getFirstAnnotationFromGivenSet(object4, JPAAnnotations.MEMBER_LEVEL)) == null) continue;
            accessType = object4.getKind() == ElementKind.FIELD ? AccessType.FIELD : AccessType.PROPERTY;
            break;
        }
        if (accessType.isDetermined()) {
            object3 = null;
            object3 = accessType == AccessType.FIELD ? ElementFilter.methodsIn(typeElement.getEnclosedElements()) : ElementFilter.fieldsIn(typeElement.getEnclosedElements());
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (Element)iterator.next();
                AnnotationMirror annotationMirror = JPAHelper.getFirstAnnotationFromGivenSet((Element)object2, JPAAnnotations.MEMBER_LEVEL);
                if (annotationMirror == null) continue;
                accessType = AccessType.INCONSISTENT;
                break;
            }
        }
        return accessType;
    }
}

