/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariableInfo;

public final class RubyVariable
extends RubyEntity {
    private final RubyVariableInfo info;
    private final RubyFrame frame;
    private final boolean isClass;
    private final boolean isLocal;
    private final boolean isInstance;
    private final boolean isConstant;
    private final boolean isGlobal;
    private final RubyValue value;
    private final RubyVariable parent;

    private RubyVariable(RubyDebuggerProxy proxy, RubyVariableInfo info, RubyFrame frame, RubyVariable parent) {
        super(proxy);
        this.info = info;
        this.isClass = info.getKind().equals("class");
        this.isLocal = info.getKind().equals("local");
        this.isInstance = info.getKind().equals("instance");
        this.isConstant = info.getKind().equals("constant");
        this.isGlobal = info.getKind().equals("global");
        this.value = new RubyValue(this, info.getValue(), info.getType(), info.hasChildren());
        this.frame = frame;
        this.parent = parent;
    }

    public RubyVariable(RubyDebuggerProxy proxy, RubyVariableInfo info) {
        this(proxy, info, null, null);
    }

    public RubyVariable(RubyVariableInfo info, RubyFrame frame) {
        this(info, frame, null);
    }

    public RubyVariable(RubyVariableInfo info, RubyVariable parent) {
        this(parent.getProxy(), info, parent.getFrame(), parent);
    }

    private RubyVariable(RubyVariableInfo info, RubyFrame frame, RubyVariable parent) {
        this(frame.getProxy(), info, frame, parent);
    }

    public String getName() {
        return this.info.getName();
    }

    public String getObjectId() {
        return this.info.getObjectId();
    }

    public RubyValue getValue() {
        return this.value;
    }

    public String getReferenceTypeName() {
        return "RefTypeName";
    }

    public boolean hasValueChanged() {
        return false;
    }

    public RubyFrame getFrame() {
        return this.frame;
    }

    public RubyVariable getParent() {
        return this.parent;
    }

    public String getQualifiedName() {
        if (this.parent == null) {
            return this.getName();
        }
        if (this.isHashValue()) {
            if (this.getValue().getReferenceTypeName().equals("String")) {
                return this.parent.getQualifiedName() + "[" + this.getName() + "]";
            }
            return "[ObjectSpace._id2ref(" + this.getObjectId() + ")]";
        }
        if (this.getName().startsWith("[")) {
            return this.parent.getQualifiedName() + this.getName();
        }
        return this.parent.getQualifiedName() + "." + this.getName();
    }

    public boolean isInstance() {
        return this.isInstance;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isHashValue() {
        return this.parent != null && this.parent.getValue().getReferenceTypeName().equals("Hash");
    }

    private boolean isNil() {
        return this.info.isNil();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyVariable other = (RubyVariable)obj;
        if (this.isNil()) {
            return other.isNil();
        }
        return this.getObjectId().equals(other.getObjectId());
    }

    public int hashCode() {
        int hash = 7;
        hash = this.isNil() ? 89 * hash + (this.isNil() ? 1 : 0) : 89 * hash + (this.info.getObjectId() != null ? this.info.getObjectId().hashCode() : 0);
        return hash;
    }

    public String toString() {
        String sep = this.isHashValue() ? " => " : " = ";
        return this.getName() + sep + this.getValue() + ", INFO: (" + this.info + ')';
    }
}

