/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebugEvent {
    private final RubyThread rubyThread;
    private final SuspensionPoint sp;
    private boolean isTerminate;

    static RubyDebugEvent createTerminateEvent() {
        RubyDebugEvent e = new RubyDebugEvent(null, null);
        e.isTerminate = true;
        return e;
    }

    public RubyDebugEvent(RubyThread rubyThread, SuspensionPoint sp) {
        if (sp != null) assert (rubyThread != null);
        this.sp = sp;
        this.rubyThread = rubyThread;
    }

    public boolean isSuspensionType() {
        return !this.isTerminate && (this.sp.isBreakpoint() || this.sp.isStep());
    }

    public boolean isTerminateType() {
        return this.isTerminate;
    }

    public boolean isExceptionType() {
        return !this.isTerminate && this.sp.isException();
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public String getFilePath() {
        return this.sp.getFile();
    }

    public int getLine() {
        return this.sp.getLine();
    }

    public boolean isStepping() {
        return this.sp.isStep();
    }

    public String toString() {
        if (this.isTerminate) {
            return "[RubyDebugEvent@" + System.identityHashCode(this) + "> Terminate Event";
        }
        return "[RubyDebugEvent@" + System.identityHashCode(this) + "> type: " + this.sp + ", rubyThread: " + this.rubyThread + ", line: " + this.sp.getLine() + ", filePath: " + this.sp.getFile() + ']';
    }
}

