/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer.regex;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedTreeBeanView;

public class MultiStateCheckBox
extends JCheckBox {
    protected final MultiStateModel model;
    private static final String PROP_PRESSED = "pressed";
    private static final String PROP_RELEASED = "released";

    public MultiStateCheckBox(String text, Object initial) {
        super(text);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MultiStateCheckBox.this.grabFocus();
                MultiStateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put(PROP_PRESSED, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiStateCheckBox.this.grabFocus();
                MultiStateCheckBox.this.model.nextState();
            }
        });
        map.put(PROP_RELEASED, null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new MultiStateModel(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public MultiStateCheckBox(String text) {
        this(text, (Object)null);
    }

    public MultiStateCheckBox() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener l) {
    }

    public final void setState(Object state) {
        this.model.setState(state);
    }

    public Object getState() {
        return this.model.getState();
    }

    private class MultiStateModel
    implements ButtonModel {
        private final ButtonModel other;

        private MultiStateModel(ButtonModel other) {
            this.other = other;
        }

        protected void setState(Object state) {
            if (state == CheckedTreeBeanView.MIXED) {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            } else if (state == CheckedTreeBeanView.SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            }
        }

        protected Object getState() {
            if (this.isSelected() && !this.isArmed()) {
                return CheckedTreeBeanView.SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return CheckedTreeBeanView.MIXED;
            }
            return CheckedTreeBeanView.UNSELECTED;
        }

        protected void nextState() {
            Object current = this.getState();
            if (current == CheckedTreeBeanView.UNSELECTED) {
                this.setState(CheckedTreeBeanView.SELECTED);
            } else {
                this.setState(CheckedTreeBeanView.UNSELECTED);
            }
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setEnabled(boolean b) {
            MultiStateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        @Override
        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

