/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.ActionEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.faces.component.FormComponent;

public class FacesRequestProcessor
extends RequestProcessor {
    protected static Log log = LogFactory.getLog((Class)FacesRequestProcessor.class);
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doForward(" + uri + ")"));
        }
        request.removeAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (this.isStrutsRequest(uri)) {
            if (response.isCommitted()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  super.doInclude(" + uri + ")"));
                }
                super.doInclude(uri, request, response);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  super.doForward(" + uri + ")"));
                }
                super.doForward(uri, request, response);
            }
            return;
        }
        LifecycleFactory lf = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lf.getLifecycle(this.getLifecycleId());
        boolean created = false;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Creating new FacesContext for '" + uri + "'"));
            }
            created = true;
            FacesContextFactory fcf = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            context = fcf.getFacesContext((Object)this.servlet.getServletContext(), (Object)request, (Object)response, lifecycle);
        }
        ViewHandler vh = context.getApplication().getViewHandler();
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Creating new view for '" + uri + "'"));
        }
        context.setViewRoot(vh.createView(context, uri));
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Rendering view for '" + uri + "'"));
        }
        try {
            lifecycle.render(context);
        }
        finally {
            if (created) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  Releasing context for '" + uri + "'"));
                }
                context.release();
            } else if (log.isTraceEnabled()) {
                log.trace((Object)"  Rendering completed");
            }
        }
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Performing standard action create");
        }
        Action result = super.processActionCreate(request, response, mapping);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Standard action create returned " + result.getClass().getName() + " instance"));
        }
        return result;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Performing standard action form processing");
            String attribute = mapping.getAttribute();
            if (attribute != null) {
                String name = mapping.getName();
                FormBeanConfig fbc = this.moduleConfig.findFormBeanConfig(name);
                if (fbc != null) {
                    if ("request".equals(mapping.getScope())) {
                        log.trace((Object)("  Bean in request scope = " + request.getAttribute(attribute)));
                    } else {
                        log.trace((Object)("  Bean in session scope = " + request.getSession().getAttribute(attribute)));
                    }
                } else {
                    log.trace((Object)("  No FormBeanConfig for '" + name + "'"));
                }
            } else {
                log.trace((Object)"  No form bean for this action");
            }
        }
        ActionForm result = super.processActionForm(request, response, mapping);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Standard action form returned " + result));
        }
        return result;
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Performing standard action perform");
        }
        ActionForward result = super.processActionPerform(request, response, action, form, mapping);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Standard action perform returned " + (result == null ? "NULL" : result.getPath()) + " forward path"));
        }
        return result;
    }

    protected boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Performing standard forward handling");
        }
        boolean result = super.processForward(request, response, mapping);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Standard forward handling returned " + result));
        }
        return result;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Performing standard forward config handling");
        }
        super.processForwardConfig(request, response, forward);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Standard forward config handling completed");
        }
    }

    protected boolean processInclude(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Performing standard include handling");
        }
        boolean result = super.processInclude(request, response, mapping);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Standard include handling returned " + result));
        }
        return result;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionEvent event = (ActionEvent)request.getAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (event == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Performing standard processPath() processing");
            }
            return super.processPath(request, response);
        }
        UIComponent component = event.getComponent();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Locating form parent for command component " + event.getComponent()));
        }
        while (!(component instanceof FormComponent)) {
            if ((component = component.getParent()) != null) continue;
            log.warn((Object)"Command component was not nested in a Struts form!");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning selected path of '" + ((FormComponent)component).getAction() + "'"));
        }
        return ((FormComponent)component).getAction();
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        UIComponent source;
        ActionEvent event = (ActionEvent)request.getAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (event == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Performing standard processPopulate() processing");
            }
            super.processPopulate(request, response, form, mapping);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Faces request, so no processPopulate() processing");
        }
        if ((source = event.getComponent()) instanceof UICommand && "cancel".equals(((UICommand)source).getId())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Faces request with cancel button pressed");
            }
            request.setAttribute("org.apache.struts.action.CANCEL", (Object)Boolean.TRUE);
        }
    }

    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException, InvalidCancelException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Performing standard validation");
        }
        boolean result = super.processValidate(request, response, form, mapping);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Standard validation processing returned " + result));
        }
        return result;
    }

    private String getLifecycleId() {
        String lifecycleId = this.servlet.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
        return lifecycleId != null ? lifecycleId : "DEFAULT";
    }

    private boolean isStrutsRequest(String uri) {
        String mapping;
        int question = uri.indexOf("?");
        if (question >= 0) {
            uri = uri.substring(0, question);
        }
        if ((mapping = (String)this.servlet.getServletContext().getAttribute("org.apache.struts.action.SERVLET_MAPPING")) == null) {
            return false;
        }
        if (mapping.startsWith("*.")) {
            return uri.endsWith(mapping.substring(1));
        }
        if (mapping.endsWith("/*")) {
            return uri.startsWith(mapping.substring(0, mapping.length() - 2));
        }
        return false;
    }
}

