/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.net.URL;
import java.util.Collection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.java.source.parsing.ClassParser;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class ClassParserFactory
extends ParserFactory {
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);

    public Parser createParser(Collection<Snapshot> snapshots) {
        ClassPath srcPath;
        ClassPath executePath;
        ClassPath compilePath;
        assert (snapshots != null);
        assert (!snapshots.isEmpty());
        FileObject file = snapshots.iterator().next().getSource().getFileObject();
        assert (file != null);
        ClassPath bootPath = ClassPath.getClassPath((FileObject)file, (String)"classpath/boot");
        if (bootPath == null) {
            bootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        if ((compilePath = ClassPath.getClassPath((FileObject)file, (String)"classpath/compile")) == null) {
            compilePath = EMPTY_PATH;
        }
        if ((executePath = ClassPath.getClassPath((FileObject)file, (String)"classpath/execute")) == null) {
            executePath = EMPTY_PATH;
        }
        if ((srcPath = ClassPath.getClassPath((FileObject)file, (String)"classpath/source")) == null) {
            srcPath = EMPTY_PATH;
        }
        ClasspathInfo cpInfo = ClasspathInfo.create(bootPath, ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{compilePath, executePath}), srcPath);
        return new ClassParser(cpInfo);
    }
}

