/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RefactoringCommit
implements Transaction {
    ArrayList<BackupFacility.Handle> ids = new ArrayList();
    private boolean commited = false;
    Collection<ModificationResult> results;
    private Set<File> newFiles = new HashSet<File>();
    private boolean newFilesStored = false;

    public RefactoringCommit(Collection<ModificationResult> results) {
        this.results = results;
    }

    public void commit() {
        try {
            if (this.commited) {
                for (BackupFacility.Handle id : this.ids) {
                    try {
                        id.restore();
                    }
                    catch (IOException ex) {
                        throw (RuntimeException)new RuntimeException().initCause(ex);
                    }
                }
            } else {
                this.commited = true;
                for (ModificationResult result : this.results) {
                    this.ids.add(BackupFacility.getDefault().backup(result.getModifiedFileObjects()));
                    this.newFiles.addAll(result.getNewFiles());
                    result.commit();
                }
            }
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public void rollback() {
        for (BackupFacility.Handle id : this.ids) {
            try {
                id.restore();
            }
            catch (IOException ex) {
                throw (RuntimeException)new RuntimeException().initCause(ex);
            }
        }
        if (this.newFiles != null) {
            for (File f : this.newFiles) {
                try {
                    FileObject fo = FileUtil.toFileObject((File)f);
                    if (!this.newFilesStored) {
                        this.ids.add(BackupFacility.getDefault().backup(new FileObject[]{fo}));
                        this.newFilesStored = true;
                    }
                    fo.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

