/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.MediaElement;
import com.sun.perseus.platform.AudioPlayer;
import com.sun.perseus.platform.MediaSupport;

public class AudioElement
extends MediaElement {
    private AudioPlayer audioPlayer;

    public AudioElement(DocumentNode ownerDocument) {
        super(ownerDocument, "audio");
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new AudioElement(doc);
    }

    void init() throws Exception {
        String url = this.getHref();
        if (url == null) {
            throw new Exception("media locator not set");
        }
        if (this.audioPlayer == null) {
            this.audioPlayer = MediaSupport.getAudioPlayer(url);
        }
    }

    void play(long startTime) {
        if (this.audioPlayer != null) {
            this.audioPlayer.play(startTime);
        }
    }

    void stop() {
        if (this.audioPlayer != null) {
            this.audioPlayer.stop();
        }
    }

    void close() {
        this.audioPlayer.close();
        this.audioPlayer = null;
    }

    void updateFrame() {
    }

    void setVolume(float volume) {
        if (this.audioPlayer != null) {
            this.audioPlayer.setVolume(volume);
        }
    }
}

