/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.panels.PIDSelectPanel;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProfilingSupport {
    private static final String QUESTION_DIALOG_CAPTION = NbBundle.getMessage(ProfilingSupport.class, (String)"CAPTION_Question");
    private static final String STOP_START_PROFILE_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartProfileSessionMessage");
    private static final String STOP_START_ATTACH_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartAttachSessionMessage");
    private static final String FAILED_LOAD_SETTINGS_MSG = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_FailedLoadSettingsMsg");
    private static ProfilingSupport defaultInstance;
    private boolean profilingActionInvoked = false;

    private ProfilingSupport() {
    }

    public static ProfilingSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingSupport();
        }
        return defaultInstance;
    }

    public static boolean checkProfilingInProgress() {
        int n = Profiler.getDefault().getProfilingState();
        int n2 = Profiler.getDefault().getProfilingMode();
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)STOP_START_PROFILE_SESSION_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return true;
                }
                Profiler.getDefault().stopApp();
            } else {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)STOP_START_ATTACH_SESSION_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return true;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        return false;
    }

    public AttachSTPData selectTaskForAttach(Project project, SessionSettings sessionSettings) {
        SelectProfilingTask.Configuration configuration = SelectProfilingTask.selectAttachProfilerTask(project);
        if (configuration == null) {
            return null;
        }
        return new AttachSTPData(configuration.getProfilingSettings(), configuration.getProject());
    }

    public ProfilingSettings selectTaskForProfiling(Project project, SessionSettings sessionSettings, FileObject fileObject, boolean bl) {
        SelectProfilingTask.Configuration configuration = SelectProfilingTask.selectProfileProjectTask(project, fileObject, bl);
        if (configuration == null) {
            return null;
        }
        return configuration.getProfilingSettings();
    }

    void setProfilingActionInvoked(boolean bl) {
        this.profilingActionInvoked = bl;
    }

    boolean isProfilingActionInvoked() {
        return this.profilingActionInvoked;
    }

    void doAttach() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AttachSTPData attachSTPData;
                    if (ProfilingSupport.checkProfilingInProgress()) {
                        return;
                    }
                    Project project = null;
                    GlobalProfilingSettings globalProfilingSettings = Profiler.getDefault().getGlobalProfilingSettings();
                    SessionSettings sessionSettings = new SessionSettings();
                    sessionSettings.setPortNo(globalProfilingSettings.getPortNo());
                    ProjectTypeProfiler projectTypeProfiler = null;
                    if (project != null) {
                        projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                    }
                    if (projectTypeProfiler != null) {
                        projectTypeProfiler.setupProjectSessionSettings(project, sessionSettings);
                    }
                    boolean bl = false;
                    ProfilingSettings profilingSettings = null;
                    while (!bl) {
                        attachSTPData = ProfilingSupport.this.selectTaskForAttach(project, sessionSettings);
                        if (attachSTPData == null) {
                            return;
                        }
                        project = attachSTPData.getProject();
                        profilingSettings = attachSTPData.getSettings();
                        ProfilerLogger.log((String)(">>> Project: " + project));
                        ProfilerLogger.log((String)(">>> Profiling settings: " + profilingSettings));
                        bl = true;
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).setProfiledProject(project, null);
                    attachSTPData = null;
                    try {
                        attachSTPData = NetBeansProfiler.loadAttachSettings(project);
                    }
                    catch (IOException iOException) {
                        Profiler.getDefault().displayWarning(MessageFormat.format(FAILED_LOAD_SETTINGS_MSG, iOException.getMessage()));
                        ProfilerLogger.log((Exception)iOException);
                    }
                    ProfilerLogger.log((String)(">>> Attach settings: " + attachSTPData));
                    if (attachSTPData == null) {
                        attachSTPData = AttachWizard.getDefault().configure((AttachSettings)attachSTPData);
                        if (attachSTPData == null) {
                            return;
                        }
                        NetBeansProfiler.saveAttachSettings(project, (AttachSettings)attachSTPData);
                    }
                    if (!attachSTPData.isRemote() && attachSTPData.isDynamic16()) {
                        int n = PIDSelectPanel.selectPID();
                        if (n == -1) {
                            return;
                        }
                        attachSTPData.setPid(n);
                    }
                    Profiler.getDefault().attachToApp(profilingSettings, (AttachSettings)attachSTPData);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                }
            }
        });
    }

    void modifyProfiling() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TargetAppRunner.getDefault().getAppStatusHandler().pauseLiveUpdates();
                    boolean bl = Profiler.getDefault().getProfilingMode() == 0;
                    SelectProfilingTask.Configuration configuration = SelectProfilingTask.selectModifyProfilingTask(NetBeansProfiler.getDefaultNB().getProfiledProject(), NetBeansProfiler.getDefaultNB().getProfiledSingleFile(), Profiler.getDefault().getProfilingMode() == 0);
                    if (configuration == null) {
                        return;
                    }
                    Profiler.getDefault().modifyCurrentProfiling(configuration.getProfilingSettings());
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                    TargetAppRunner.getDefault().getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public static class AttachSTPData {
        private ProfilingSettings ps;
        private Project p;

        private AttachSTPData(ProfilingSettings profilingSettings, Project project) {
            this.ps = profilingSettings;
            this.p = project;
        }

        public Project getProject() {
            return this.p;
        }

        public ProfilingSettings getSettings() {
            return this.ps;
        }
    }
}

