/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.ArgumentNode;
import org.jruby.nb.ast.MethodDefNode;
import org.jruby.nb.ast.NilNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.internal.runtime.methods.DefaultMethod;
import org.jruby.nb.internal.runtime.methods.WrapperMethod;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class DefnNode
extends MethodDefNode
implements INameNode {
    private final Visibility visibility;

    public DefnNode(ISourcePosition position, ArgumentNode nameNode, ArgsNode argsNode, StaticScope scope, Node bodyNode, Visibility visibility) {
        super(position, nameNode, argsNode, scope, bodyNode, NodeType.DEFNNODE);
        this.visibility = visibility;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefnNode(this);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public String getName() {
        return this.nameNode.getName();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.nameNode, this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule containingClass = context.getRubyClass();
        if (containingClass == runtime.getDummy()) {
            throw runtime.newTypeError("no class/module to add method");
        }
        String name = this.getName();
        if (containingClass == runtime.getObject() && name == "initialize") {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
        }
        if (name == "__id__" || name == "__send__") {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name + "' may cause serious problem", name);
        }
        Visibility visibility = context.getCurrentVisibility();
        if (name == "initialize" || name == "initialize_copy" || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        this.scope.determineModule();
        Node body = this.bodyNode == null ? new NilNode(this.getPosition()) : this.bodyNode;
        DefaultMethod newMethod = new DefaultMethod(containingClass, this.scope, body, this.argsNode, visibility, this.getPosition());
        containingClass.addMethod(name, newMethod);
        if (context.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
            containingClass.getSingletonClass().addMethod(name, new WrapperMethod((RubyModule)containingClass.getSingletonClass(), newMethod, Visibility.PUBLIC));
            containingClass.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        }
        if (containingClass.isSingleton()) {
            ((MetaClass)containingClass).getAttached().callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        } else {
            containingClass.callMethod(context, "method_added", runtime.fastNewSymbol(name));
        }
        return runtime.getNil();
    }
}

