/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyString;
import org.jruby.nb.ast.DStrNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.StrNode;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DXStrNode
extends ListNode
implements ILiteralNode {
    public DXStrNode(ISourcePosition position, DStrNode node) {
        super(position, NodeType.DXSTRNODE);
        this.addAll(node);
    }

    public DXStrNode(ISourcePosition position) {
        super(position, NodeType.DXSTRNODE);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDXStrNode(this);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < this.size(); ++i) {
            Node iterNode = this.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(iterNode.interpret(runtime, context, self, aBlock));
        }
        return self.callMethod(context, "`", string);
    }
}

